<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\components\helpers\Frequencies;
use backend\components\helpers\JsTools;
?>
<div class="row">
    <div class="col-lg-12">

        <div class="col-head">
            <h3>Income</h3>
            <a href="#" class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/incomes/add-income', 'js_callback' => 'reloadFirstTimeSetupIncomes']) ?>">Add a New Income</a>
        </div>

        <div class="panel panel-tabbed incomes-panel">
            <div class="tabpanel tabpanel-secondary">
                <div class="container-fluid">
                    <?php if (count($incomes) > 0) { ?>
                    <div class="row no-gutter">
                        <div class="col-lg-6 no-float tab-col">
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs" role="tablist">
                                <?php foreach ($incomes as $key => $i) { ?>
                                <li role="presentation"<?php if ($key == 0) { ?> class="active"<?php } ?> data-income-id="<?= $i->id ?>">
                                    <a href="#inc<?= $i->id ?>" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true">
                                        <span class="clearfix">
                                            <span class="pull-left"><?= $i->name ?></span>
                                            <span class="pull-right"><?= Formatter::currency($i->amount) ?></span>
                                        </span>
                                    </a>
                                </li>
                                <?php } ?>
                            </ul>
                        </div>
                        <div class="col-lg-6 no-float">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <?php foreach ($incomes as $key => $i) { ?>
                                <div role="tabpanel" class="tab-pane<?php if ($key == 0) { ?> active<?php } ?>" id="inc<?= $i->id ?>" data-income-id="<?= $i->id ?>">
                                    <div class="col-head">
                                        <h3><?= $i->name; ?></h3>
                                        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/incomes/edit-income', 'id' => $i->id, 'js_callback' => 'reloadFirstTimeSetupIncomes']) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                                        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/incomes/remove-income', 'id' => $i->id, 'js_callback' => 'reloadFirstTimeSetupIncomes']) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-5">
                                            <div class="label-group">
                                                <label>Frequency</label>
                                                <span class="label-value"><?= Frequencies::getLabel($i->frequency) ?></span>
                                            </div>
                                            <div class="label-group">
                                                <label>Date of Next Pay Day</label>
                                                <span class="label-value"><?= Formatter::date($i->getNextDue()) ?></span>
                                            </div>
                                            <div class="label-group">
                                                <label>Amount</label>
                                                <span class="label-value"><?= Formatter::currency($i->amount) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php } else { ?>
                    <div class="row">
                        <div class="col-lg-12 no-float">
                            <p style="padding:20px;">No incomes yet.</p>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
