<?php
use backend\widgets\BudgetShortfallCalculator;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\components\helpers\Frequencies;
use backend\components\helpers\JsTools;
?>
<div class="row">
    <div class="col-lg-12">

        <div class="col-head">
            <h3>People on Your Account</h3>
            <a href="<?= Url::toRoute(['/first-time-setup/step-' . 1]) ?>" class="btn btn-primary btn-sm">Edit People</a>
        </div>
        <div class="clearfix">
            <?php foreach ($users as $u) { ?>
            <div class="user-profile">
                <div class="avatar">
                    <img src="<?= $u->getAvatarUrl() ?>" alt="avatar">
                </div>
                <div class="username"><?= $u->username ?></div>
                <div><?= $u->meta['full_name'] ?></div>
                <div><?= $u->email ?></div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>
<hr />

<div class="row">
    <div class="col-md-12">
        <div class="col-head">
            <h3>Position Summary</h3>
        </div>
    </div>
</div>
<div class="row jar-header-info">
    <div class="col-50">
        <div class="item-value">
            <div class="value"><?= Formatter::currency($minMonthlyIncome) ?></div>
            <div class="desc">Minimum Monthly Income</div>
        </div>
    </div>
    <div class="col-50">
        <div class="item-value">
            <div class="value"><?= Formatter::currency($avgMonthlyIncome) ?></div>
            <div class="desc">Average Monthly Income</div>
        </div>
    </div>
    <div class="col-50">
        <div class="item-value">
            <div class="value"><?= Formatter::currency($totalMonthlyBudget) ?></div>
            <div class="desc">Monthly Jar Allocation</div>
        </div>
    </div>
    <div class="col-50">
        <div class="item-value">
            <div class="value<?= ($minMonthlySurplus >= 0) ? ' text-success' : ' value-red'; ?>"><?= Formatter::currency($minMonthlySurplus) ?></div>
            <div class="desc">Minimum Monthly Surplus</div>
        </div>
    </div>
    <div class="col-50">
        <div class="item-value">
            <div class="value<?= ($avgMonthlySurplus >= 0) ? ' text-success' : ' value-red'; ?>"><?= Formatter::currency($avgMonthlySurplus) ?></div>
            <div class="desc">Average Monthly Surplus</div>
        </div>
    </div>
</div>
<hr />

<div class="row">
    <div class="col-sm-4">
        <div class="col-head">
            <h3>Bank Accounts</h3>
            <a href="<?= Url::toRoute(['/first-time-setup/step-' . 2]) ?>" class="btn btn-primary btn-sm">Edit Accounts</a>
        </div>
        <div class="clearfix">
            <div class="panel panel-table col-lg-10 col-sm-12">
                <ul class="info-list">
                    <?php foreach ($accounts as $a) { ?>
                    <li>
                        <div class="info">
                            <h4><?= $a->name ?></h4>

                            <p>Opening Balance<span><?= Formatter::currency($a->balance) ?></span></p>

                            <p>Type of Account<span><?= $a->accountType->name ?></span></p>
                        </div>
                    </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="col-head">
            <h3>Debts</h3>
            <a href="<?= Url::toRoute(['/first-time-setup/step-' . 3]) ?>" class="btn btn-primary btn-sm">Edit Debts</a>
        </div>
        <div class="clearfix">
            <div class="panel panel-table col-lg-10 col-md-12">
                <ul class="info-list">
                    <?php if (count($debts) > 0) { ?>
                    <?php foreach ($debts as $d) { ?>
                    <li>
                        <div class="info">
                            <h4><?= $d->name ?></h4>

                            <p>Balance Owed<span><?= Formatter::currency($d->amount) ?></span></p>

                            <p>Interest Rate<span><?= $d->interest ?>%</span></p>

                            <p>Type of Debt<span><?= $d->debtType->name ?></span></p>
                        </div>
                    </li>
                    <?php } ?>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="col-head">
            <h3>Income</h3>
            <a href="<?= Url::toRoute(['/first-time-setup/step-' . 4]) ?>" class="btn btn-primary btn-sm">Edit Income</a>
        </div>
        <div class="clearfix">
            <div class="panel panel-table col-lg-10 col-md-12">
                <ul class="info-list">
                    <?php if (count($incomes)) { ?>
                    <?php foreach ($incomes as $i) { ?>
                    <li>
                        <div class="info">
                            <h4><?= $i->name ?></h4>

                            <p>Amount<span><?= Formatter::currency($i->amount) ?></span></p>

                            <p>Frequency<span><?= Frequencies::getLabel($i->frequency) ?></span></p>

                            <p>Next Payday<span><?= Formatter::date($i->getNextDue()) ?></span></p>
                        </div>
                    </li>
                    <?php } ?>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<hr />

<div class="row">
    <div class="col-lg-12">

        <div class="col-head">
            <h3>Jars &amp; Expenses</h3>
            <a href="<?= Url::toRoute(['/first-time-setup/step-' . 5]) ?>" class="btn btn-primary btn-sm">Edit Jars</a>
        </div>
        <div class="grid jar-grid">
            <?php foreach ($jars as $j) { ?>
                <div class='grid-item panel'>
                    <div class='grid-item-icon'>
                        <img src="<?= Url::to('@web/imgs/jar.svg') ?>" width="45" alt="Grandmas Jars">
                    </div>
                    <h4 class='grid-item-title'>
                        <?= $j->name ?>
                    </h4>
                    <div class='jar-grid-total'><?= Formatter::currency($j->getMonthlyBudget()) ?></div>
                    <div class='grid-item-body'>
                        <?php
                            $expenses = $j->getActiveExpenses();
                            if (count($expenses)) {
                        ?>
                            <p><strong>Expenses:</strong></p>
                            <ul class='jar-grid-expenses'>
                                <?php foreach ($expenses as $e) { ?>
                                    <li class='jar-grid-expense'>
                                        <div class='jar-grid-expense-amount'>
                                            <?= $e->amount ?>
                                        </div>
                                        <?= $e->name ?>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
<hr/>

<?= BudgetShortfallCalculator::widget([
    'budgetId' => $budgetId,
    'containerClass' => 'mt20',
    'callbackUrl' => Url::to(['/jars/budget-shortfall-calculator'])
]) ?>