<?php

use backend\models\db\Jar;
use backend\widgets\FormattedTitle;
use backend\widgets\JarTooltip;
use yii\helpers\Url;
?>

<div role="tabpanel" class="tab-pane active" data-js-callback="firstTimeSetupStep5DetailLoaded" data-jar-id="<?= $jar->id?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $jar->name ?></h3>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/edit-expense-jar', 'id' => $jar->id, 'js_callback' => 'reloadFirstTimeSetupJars']) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                <?php if ($jar->type != Jar::EVERYDAY_JAR_TYPE) { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/remove-expense-jar', 'id' => $jar->id, 'js_callback' => 'reloadFirstTimeSetupJarsAfterRemove']) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                <?php } ?>
                <?= JarTooltip::widget(['type' => $jar->type]) ?>
            </div>
        </div>
    </div>

    <?= $jar->jar_type_id == 1 ?
        $this->render('_expense-jar-detail-content', [
            'jar' => $jar
        ]) :
        $this->render('_debt-jar-detail-content', [
            'jar' => $jar,
            'budget' => $budget
        ]); ?>
</div>
