<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>

<div id="body" class="container-fluid no-nav" data-js-callback="firstTimeSetupStep<?= $currentStepId ?>DetailLoaded" data-first-setup-step="<?= $currentStepId ?>" data-select-menu="li#dashboard-nav" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-lg-12">
            <?=
            $this->render('_progress-nav', [
                'currentStepId' => $currentStepId,
                'steps' => $steps,
                'stepProgress' => $stepProgress
            ]);
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">

            <div class="col-head">
                <h3>Jars &amp; Expenses</h3>
                <a href="#" class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/jars/create-expense-jar', 'js_callback' => 'reloadFirstTimeSetupJars']) ?>">Add a New Jar</a>
                <a class="btn btn-primary btn-sm reorder-jars" data-budget-id="">
                    <i class="glyphicon glyphicon-move"></i>
                    <span class='text'>Reorder Jars</span>
                    <span class='active-text'>Save Order</span>
                </a>
            </div>

            <div class="panel panel-tabbed with-balanced-bar jars-panel">
                <div class="tabpanel tabpanel-secondary">
                    <div class="container-fluid">
                        <div class="row no-gutter">
                            <div class="col-lg-6 no-float tab-col">
                                <!-- Nav tabs -->
                                <?= $this->render('_step-5-jars-list', [
                                    'jars' => $jars,
                                    'jar' => $jar
                                ]); ?>
                            </div>
                            <div class="col-lg-6 no-float">
                                <!-- Tab panes -->
                                <div class="tab-content body-content step-5-jar-container" data-block-loading="true">
                                    <?= $this->render('step-5-jar-detail-content', [
                                        'jar' => $jar,
                                        'budget' => $budget
                                    ]); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?= $this->render('_step-5-balance-bar', [
                        'totalIncomesAmount' => $totalIncomesAmount,
                        'totalExpensesAmount' => $totalExpensesAmount,
                        'incomesPctg' => $incomesPctg,
                        'expensesPctg' => $expensesPctg
                    ]); ?>

                </div>
            </div>
        </div>
    </div>

    <?= $this->render('_fts-nav', [
        'currentStepId' => $currentStepId,
        'stepProgress' => $stepProgress
    ]); ?>

    <?= $this->render('/layouts/_footer') ?>

</div>
