<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<table id="it-table-1" class="table table-paginated table-bordered data-table secondary-date-sorting" data-table-id="it-table-1" data-ajax="<?= Url::toRoute([
    '/income-transactions/income-transactions-table',
    'income_id' => isset($income) ? $income->id : 0,
    'budget_id' => isset($budgetId) ? $budgetId : false,
    'month' => $month,
    'year' => $year
]) ?>">
    <thead>
        <tr>
            <th class="sort-by sort-desc">Date</th>
            <th>Income</th>
            <th>Description</th>
            <th>Amount</th>
            <th>Account</th>
            <?php if ($allowEdit) { ?>
            <th class="no-sort"></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="<?= ($allowEdit) ? 6 : 5; ?>">No income transactions yet.</td>
        </tr>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="<?= ($allowEdit) ? 5 : 4; ?>">Total Transactions</td>
            <td class="this-months-income-transactions-amount"><?= Formatter::currency($incomeTransactionsAmount) ?></td>
        </tr>
    </tfoot>
</table>
