<?php
use backend\components\ActiveForm;
use backend\components\helpers\JsTools;
use backend\components\helpers\Formatter;
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-income-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'name')->label('Income Description') ?>

    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ])->label('Income Per Pay Period') ?>

    <?= $form->field($formModel, 'frequency')
            ->dropDownList($frequencies, ['prompt' => 'Select one']) ?>

    <?= $form->field($formModel, 'formattedDate')
            ->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
                'template' => '{input}{button}',
                'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                'clientOptions' => [
                    'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                    'minView' => 'month',
                    'maxView' => 'year',
                    'autoclose' => true
                ]
            ])
            ->label('Date of Next Pay Day')
            ->hint('Entering the date of your next pay day will help determine which months will be 3 pay months if you get paid fortnightly and which will be 5 pay months if you get paid weekly.')
    ?>

    <?= $form->field($formModel, 'account_id')->dropDownList($accounts, [
            'prompt' => 'Select one',
            'options' => [
                $selectedAccount => ['selected'=>true]
            ]
        ])->label('Account Receiving Income') ?>

    <?= $form->field($formModel, 'jar_id', ['options' => ['class' => 'form-group hidden']])
        ->dropDownList($jars, ['prompt' => 'Select one'])
        ->label('Jar') ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Income', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadIncomesAfterAdd'), 'data-submit-url' => Url::toRoute(['/incomes/add-income', 'budget_id' => (isset($budgetId) ? $budgetId : false)])]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


