<?php
use yii\bootstrap\ButtonDropdown;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\widgets\VideoTutorial;
?>

<?php if (isset($isMockBudget) && $isMockBudget) { ?>
<div id="body" class="container-fluid is-mock-budget" data-js-callback="incomesLoaded" data-select-menu="li#my-financials-income" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>" data-mock-budget-id="<?= $budgetId ?>">
<?php } else { ?>
<div id="body" class="container-fluid" data-js-callback="incomesLoaded" data-select-menu="li#my-financials-income" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
<?php } ?>
    <?= VideoTutorial::widget(['type' => 'incomes']) ?>
    <?php if (isset($isMockBudget) && $isMockBudget) {
        echo $this->render('/mock-budgets/_mock-budget-header', [
            'budgetId' => $budgetId,
            'budgetName' => $budgetName,
            'pageTitle' => 'Incomes',
        ]);
    } ?>

    <div class="row income-detail-headline" data-target-selector=".income-detail-headline"<?php if (!$this->params['pageLoadRequest'] && !$fullLoad) { ?> data-partial-load="1"<?php } ?>>
        <div class="col-md-12">
            <div class="col-head">
                <h2>Income</h2>
                <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/incomes/add-income', 'budget_id' => (isset($isMockBudget) && $isMockBudget) ? $budgetId : false]) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
            </div>
            <div class="panel panel-tabbed">
                <div class="tabpanel tabpanel-secondary">
                    <div class="container-fluid">
                        <div class="row no-gutter income-row">
                            <?php if (count($incomes)) { ?>
                            <div class="col-lg-6 no-float tab-col">
                                <!-- Nav tabs -->
                                <?= $this->render('_incomes-list', [
                                    'incomes' => $incomes,
                                    'title' => ($allowEdit) ? 'My Incomes' : 'Deleted Incomes',
                                    'allowEdit' => $allowEdit
                                ]); ?>
                            </div>
                            <div class="col-lg-6 no-float">
                                <!-- Tab panes -->
                                <div class="tab-content body-content income-container" data-block-loading="true">
                                    <div class="tab-pane active loading-pane">Loading...</div>
                                </div>
                            </div>
                            <?php } else { ?>
                            <div class="col-lg-12 no-float">
                                <div class="tab-pane active loading-pane">No incomes yet.</div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="col-head">
                <h4>Income Transactions</h4>
            </div>
        </div>
        <div class="col-sm-3">
            <?= ButtonDropdown::widget([
                'label' => $year,
                'dropdown' => [
                    'items' => $years,
                ]
            ]); ?>
            <?= ButtonDropdown::widget([
                'label' => $monthName,
                'dropdown' => [
                    'items' => $months,
                ]
            ]); ?>
        </div>
        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="it-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row income-detail-transactions" data-target-selector=".income-detail-transactions"<?php if (!$this->params['pageLoadRequest'] && !$fullLoad) { ?> data-partial-load="1"<?php } ?>>
        <div class="col-md-12">
            <div class="panel panel-table">
                <?= $this->render('/income-transactions/_income-transactions-table', [
                    'incomeTransactionsAmount' => $incomeTransactionsAmount,
                    'budgetId' => isset($budgetId) ? $budgetId : false,
                    'allowEdit' => $allowEdit,
                    'month' => $month,
                    'year' => $year
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h4>Incomes</h4>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="i-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row incomes-table">
        <div class="col-md-12">
            <div class="panel panel-table">
                <?= $this->render('_incomes-table', [
                    'budgetId' => isset($budgetId) ? $budgetId : false,
                    'totalAverageIncome' => $totalAverageIncome,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row incomes-graphs">
        <div class="col-md-12">
            <div class="panel panel-tabbed">
                <div class="tabpanel">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#income-month" aria-controls="home" role="tab" data-toggle="tab">Income by Month</a></li>
                        <li role="presentation"><a href="#income-day" aria-controls="profile" role="tab" data-toggle="tab">Income by Day</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane panel-paged active" id="income-month">
                            <?= $this->render('/income-transactions/_income-transactions-graph-by-year', [
                                'budgetId' => isset($budgetId) ? $budgetId : false
                            ]) ?>
                        </div>

                        <div role="tabpanel" class="tab-pane panel-paged" id="income-day">
                            <?= $this->render('/income-transactions/_income-transactions-graph-by-month', [
                                'budgetId' => isset($budgetId) ? $budgetId : false
                            ]) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
