<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'remove-income-form']); ?>
<div class="modal-body">

    <p>Do you really wish to remove this income?</p>
    <?php if ($hardDeletable) { ?>
    <ul>
        <li><strong>Delete Income</strong> when the income is no longer valid (keeps past income data)</li>
        <li><strong>Delete Income and all Associated Transactions</strong> when the income was added in a mistake (deletes all past and current data)</li>
    </ul>
    <?php } else { ?>
    <p>This <strong>will keep</strong> past income data.</p>
    <?php } ?>

    <?php if (isset($frequency) && ($frequency == 'one-time') && $hardDeletable) { ?>
    <p class="note">Removing this income will remove all associated income transactions.</p>
    <?php } ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Delete Income', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadIncomesAfterRemove'), 'data-submit-url' => Url::toRoute(['/incomes/remove-income', 'id' => $incomeId, 'confirm' => 1])]) ?>
    <?php if ($hardDeletable) { ?>
    <?= Html::submitButton('Delete Income and all Associated Transactions', ['class' => 'btn btn-danger ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadIncomesAfterRemove'), 'data-submit-url' => Url::toRoute(['/incomes/remove-income', 'id' => $incomeId, 'confirm' => 1, 'hard' => 1])]) ?>
    <?php } ?>
</div>
<?php ActiveForm::end(); ?>
