<?php
use backend\components\helpers\Formatter;
use backend\models\db\Budget;
use backend\models\db\Jar;

/** @var Jar $jar */
/** @var Budget $budget */
?>


<div class="col-md-3">
  <div class="item-value">
    <div class="value jar-amount"><?= Formatter::currency($jar->getThisMonthsFundsBroughtForwardAmount()); ?></div>
    <div class="desc">Accumulated Funds</div>
  </div>
</div>
<div class="col-md-3">
  <div class="item-value">
    <div class="value this-months-expenses-amount"><?= Formatter::currency($jar->getMonthlyBudget()); ?></div>
    <div class="desc">Monthly Budget</div>
  </div>
</div>
<div class="col-md-3">
  <div class="item-value">
    <div class="value this-months-transactions-amount"><?= Formatter::currency($jar->getThisMonthsTransactionsAmount(false, false)); ?></div>
    <div class="desc">Amount Spent</div>
  </div>
</div>
<div class="col-md-3">
  <div class="item-value">
    <div class="value this-months-funds-remaining"><?= Formatter::currency($jar->getThisMonthsFundsRemainingAmount()); ?></div>
    <div class="desc">Funds Remaining</div>
  </div>
</div>

