<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
?>
<!---------------------------------------------------------------
Secondary Navigation
---------------------------------------------------------------->
<?= $this->render('_jars-list', [
    'budget' => $budget,
    'jars' => $jars,
    'jar' => $jar,
    'title' => ($allowEdit) ? 'My Jars' : 'Deleted Jars',
    'allowEdit' => $allowEdit
]); ?>
<!---------------------------------------------------------------
End Secondary Navigation
---------------------------------------------------------------->

<!---------------------------------------------------------------
Body
---------------------------------------------------------------->
<div class="jar-container content-container" data-block-loading="true">

<?= $this->render('debt-jar-detail-content', [
    'budget' => $budget,
    'jar' => $jar,
    'debts' => $debts,
    'totalDebtAmount' => $totalDebtAmount,
    'totalDebtPaid' => $totalDebtPaid,
    'debtPayments' => $debtPayments,
    'debtNames' => $debtNames,
    'allowEdit' => $allowEdit,
    'budgetId' => (isset($budgetId) ? $budgetId : false),
    'budgetName' => (isset($budgetName) ? $budgetName : false),
    'isMockBudget' => (isset($isMockBudget) ? $isMockBudget : false),
    'year' => $year,
    'month' => $month,
    'monthName' => $monthName,
    'years' => $years,
    'months' => $months
]); ?>

</div>
<!---------------------------------------------------------------
End Body
---------------------------------------------------------------->


