<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\JsTools;
use backend\widgets\VideoTutorial;
?>

<!---------------------------------------------------------------
Secondary Navigation
---------------------------------------------------------------->
<?= $this->render('_jars-list', [
    'budget' => $budget,
    'jars' => $jars,
    'allowEdit' => $allowEdit
]); ?>
<!---------------------------------------------------------------
End Secondary Navigation
---------------------------------------------------------------->

<!---------------------------------------------------------------
Body
---------------------------------------------------------------->
<div class="jar-container" data-block-loading="true">
    <?php if (isset($isMockBudget) && $isMockBudget) { ?>
    <div id="body" class="container-fluid secondary-nav is-mock-budget" data-js-callback="jarsLoaded" data-select-menu="<?= ($allowEdit) ? 'li#my-jars-jars' : 'li#my-jars-deleted-jars'; ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>" data-mock-budget-id="<?= $budgetId ?>">
    <?php } else { ?>
    <div id="body" class="container-fluid secondary-nav" data-js-callback="jarsLoaded" data-select-menu="<?= ($allowEdit) ? 'li#my-jars-jars' : 'li#my-jars-deleted-jars'; ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?php } ?>
        <?= VideoTutorial::widget(['type' => $allowEdit ? 'jars' : 'deleted-jars']) ?>
        <div class="row">
            <div class="col-md-12">
                <div class="panel">
                    <?= count($jars) ? 'Loading...' : 'No jars yet.'; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!---------------------------------------------------------------
End Body
---------------------------------------------------------------->
