<?php use yii\helpers\Url; ?>
<nav id="side-bar" class="navmenu navmenu-default navmenu-fixed-left offcanvas" role="navigation">
    <ul id="side-bar-nav" class="nav navmenu-nav panel-group" role="tablist" aria-multiselectable="true">
        <?php if (in_array($initUserRole, ['superadmin', 'coach'])) { ?>
        <li class="panel admin-menu">
            <div class="panel-heading clearfix">
                <?php if (($userRole == 'superadmin') || (($userRole != 'coach') && ($initUserRole == 'superadmin'))) { ?>
                <a href="<?= Url::toRoute('/admin/default/admin-dashboard')?>" class="pull-left"><span class="icon-goals"></span> Administration</a>
                <?php } else { ?>
                <a href="<?= Url::toRoute('/admin/default/coach-dashboard')?>" class="pull-left"><span class="icon-goals"></span> Administration</a>
                <?php } ?>
                <button id="admin-dropdown" class="side-bar-nav-section-toggle dropdown-toggle pull-right" data-parent="#side-bar-nav" data-target="#admin-submenu" data-toggle="collapse" aria-expanded="false"><span class="glyphicon glyphicon-plus"></span></button>
            </div>
            <ul id="admin-submenu" class="collapse list-group navmenu-nav" role="menu" aria-labelledby="admin-dropdown">
                <?php if (($userRole == 'superadmin') || (($userRole != 'coach') && ($initUserRole == 'superadmin'))) { ?>
                <li id="admin-dashboard"><a href="<?= Url::toRoute('/admin/default/admin-dashboard')?>">Dashboard</a></li>
                <?php } else { ?>
                <li id="coach-dashboard"><a href="<?= Url::toRoute('/admin/default/coach-dashboard')?>">Dashboard</a></li>
                <?php } ?>
                <li id="admin-users"><a href="<?= Url::toRoute('/admin/user/index/')?>">Users</a></li>
                <?php if ($userRole == 'coach') { ?>
                <li id="admin-notes"><a href="<?= Url::toRoute('/admin/notes/index/')?>">Notes</a></li>
                <?php } ?>
                <?php if ($adminSelectedUserId) { ?>
                <li><a href="<?= Url::toRoute('/admin/user/switch-back/')?>">&lt; Back to my user</a></li>
                <?php } ?>
                <?php if (($userRole == 'superadmin') || (($userRole != 'coach') && ($initUserRole == 'superadmin'))) { ?>
                <li id="admin-coaches"><a href="<?= Url::toRoute('/admin/user/coaches/')?>">Coaches</a></li>
                <li id="admin-sessions"><a href="<?= Url::toRoute('/admin/appointments/overview')?>">Session Bookings</a></li>
                <li id="admin-faq-categories"><a href="<?= Url::toRoute('/admin/faq-category/index/')?>">FAQ Categories</a></li>
                <li id="admin-faq-questions"><a href="<?= Url::toRoute('/admin/faq-question/index/')?>">FAQ Questions</a></li>
                <li id="admin-bugs"><a href="<?= Url::toRoute('/admin/bugs/index/')?>">Bugs</a></li>
                <?php } else { ?>
                <li id="admin-conversations"><a href="<?= Url::toRoute('/admin/coach/index')?>">Communication</a></li>
                <li id="admin-appointments"><a href="<?= Url::toRoute('/admin/coach/appointments')?>">Appointments</a></li>
                <?php } ?>
            </ul>
        </li>
        <?php } ?>
        <?php if (in_array($userRole, ['client', 'sub-client', null])) { ?>
        <?php /*<li class="panel lessons" id="lessons-nav">
            <div class="panel-heading">
                <a href="<?= Url::toRoute('/lessons')?>"><span class="glyphicon glyphicon-flag"></span> Lessons</a>
            </div>
        </li>*/ ?>
        <li class="panel dashboard active" id="dashboad-nav">
            <div class="panel-heading">
                <a href="<?= Url::to('@web/')?>"><span class="icon-dashboard"></span> Dashboard</a>
            </div>
        </li>
        <li id="class panel transactions">
            <div class="panel-heading">
                <a href="<?= Url::toRoute('/money-operations/index')?>">
                    <span class="glyphicon glyphicon-transfer"></span> Transactions
                </a>
            </div>
        </li>
        <li id="class panel jar-summary">
            <div class="panel-heading">
                <a href="<?= Url::toRoute('/budget/jar-summary')?>">
                    <span class="glyphicon glyphicon-list"></span> Jar Summary
                </a>
            </div>
        </li>
        <li class="panel budgeting-tools">
            <div class="panel-heading clearfix">
                <a href="<?= Url::toRoute('/budget/position-summary')?>" class="pull-left"><span class="icon-budget"></span> Budgeting Tools</a>
                <button id="budgeting-tools-dropdown" class="side-bar-nav-section-toggle dropdown-toggle pull-right" data-parent="#side-bar-nav" data-target="#budgeting-tools-submenu" data-toggle="collapse" aria-expanded="false"><span class="glyphicon glyphicon-plus"></span></button>
            </div>
            <ul id="budgeting-tools-submenu" class="collapse list-group navmenu-nav" role="menu" aria-labelledby="budgeting-tools-dropdown">
                <li id="budgeting-tools-position-summary"><a href="<?= Url::toRoute('/budget/position-summary')?>">Position Summary</a></li>
                <li id="budgeting-tools-eom-summary"><a href="<?= Url::toRoute('/budget/end-of-month-summary')?>">End of Month Summary</a></li>
                <li id="budgeting-tools-mock-budgets"><a href="<?= Url::toRoute('/mock-budgets')?>">Mock Budgets</a></li>
                <li id="budgeting-tools-calculator"><a href="<?= Url::toRoute('/budget/calculator')?>">Shortfall Calculator</a></li>
            </ul>
        </li>
        <li class="panel my-jars mock-budget-visible">
            <div class="panel-heading clearfix">
                <a href="<?= Url::toRoute('/jars/index')?>" class="pull-left"><span class="icon-jar"></span> My Jars</a>
                <button id="my-jars-dropdown" class="side-bar-nav-section-toggle dropdown-toggle pull-right" data-parent="#side-bar-nav" data-target="#my-jars-submenu" data-toggle="collapse" aria-expanded="false"><span class="glyphicon glyphicon-plus"></span></button>
            </div>
            <ul id="my-jars-submenu" class="collapse mock-budget-visible list-group navmenu-nav" role="menu" aria-labelledby="my-jars-dropdown">
                <li id="my-jars-jars" class="mock-budget-visible"><a href="<?= Url::toRoute('/jars/index')?>">Jars</a></li>
                <!-- <li id="my-jars-summaries"><a href="#">Summaries</a></li> -->
                <li id="my-jars-deleted-jars" class="mock-budget-visible"><a href="<?= Url::toRoute('/jars/deleted-jars')?>">Deleted Jars</a></li>
            </ul>
        </li>
        <!-- <li class="panel my-goals">
            <div class="panel-heading">
                <a id="my-goals" href=""><span class="icon-goals"></span> My Goals</a>
            </div>
        </li> -->
        <li class="panel coach">
            <div class="panel-heading">
                <a id="coach" href="<?= Url::to(['/coach']) ?>"><span class="icon-coach"></span> Coach</a>
            </div>
        </li>
        <li class="panel my-financials mock-budget-visible">
            <div class="panel-heading clearfix">
                <a href="<?= Url::toRoute('/accounts/index')?>" class="pull-left"><span class="icon-card"></span> My Financials</a>
                <button id="my-financials-dropdown" class="side-bar-nav-section-toggle dropdown-toggle pull-right" data-parent="#side-bar-nav" data-target="#my-financials-submenu" data-toggle="collapse" aria-expanded="false"><span class="glyphicon glyphicon-plus"></span></button>
            </div>
            <ul id="my-financials-submenu" class="collapse mock-budget-visible list-group navmenu-nav" role="menu" aria-labelledby="my-financials-dropdown">
                <li id="my-financials-accounts" class="mock-budget-visible"><a href="<?= Url::toRoute('/accounts/index')?>">Accounts</a></li>
                <li id="my-financials-income" class="mock-budget-visible"><a href="<?= Url::toRoute('/incomes/index')?>">Income</a></li>
                <li id="my-financials-transfers"><a href="<?= Url::toRoute('/transfers/index')?>">Transfers</a></li>
                <li id="my-financials-debts" class="mock-budget-visible"><a href="<?= Url::toRoute('/debts/index')?>">Debts</a></li>
            </ul>
        </li>
        <li class="panel go-back only-mock-budget-visible mock-budget-visible hidden">
            <div class="panel-heading">
                <a href="<?= Url::toRoute(['/mock-budgets/budget-detail']) ?>" class="system-link">
                    <span class="glyphicon glyphicon-menu-left"></span> Go back to mock budget
                </a>
            </div>
        </li>
        <li class="panel" id="mainnav-reports">
            <div class="panel-heading">
                <a href="<?= Url::toRoute('/reports')?>"><span class="icon-reports"></span> Reports</a>
            </div>
        </li>
        <li class="panel">
            <div class="panel-heading clearfix">
                <a href="<?= Url::to(['/faq']) ?>" id="support" class="pull-left"><span class="icon-support"></span> Support</a>
                <button id="support-dropdown" class="side-bar-nav-section-toggle dropdown-toggle pull-right" data-parent="#side-bar-nav" data-target="#support-submenu" data-toggle="collapse" aria-expanded="false"><span class="glyphicon glyphicon-plus"></span></button>
            </div>
            <ul id="support-submenu" class="collapse list-group navmenu-nav" role="menu">
                <!-- <li id="support-main"><a href="<?= Url::to(['/support']) ?>">Support</a></li> -->
                <li id="support-faq"><a href="<?= Url::to(['/faq']) ?>">FAQ</a></li>
            </ul>

        </li>
        <?php } ?>
    </ul>
</nav>