<?php

use backend\assets\AppAsset;
use backend\models\db\Eoms;
use backend\models\db\UserPlan;
use backend\models\db\UserPlanType;
use kartik\switchinput\SwitchInputAsset;
use yii\helpers\Html;
use yii\helpers\Url;

use backend\components\helpers\Formatter;

use backend\widgets\UnreadConversationMessages;
use backend\widgets\UnreadNotifications;

AppAsset::register($this);
SwitchInputAsset::register($this);

$adminSelectedUserId = Yii::$app->session->get('adminSelectedUserId') ? Yii::$app->session->get('adminSelectedUserId') : false;
if (isset($this->context->activeBudgetId)) {
    $eoms = Eoms::getLastEoms($this->context->activeBudgetId);
}

$checkSubscription = false;
if ($this->params['userRole'] == 'superadmin') {
    $dashboardUrl = Url::toRoute('/admin/default/admin-dashboard');;
}
elseif ($this->params['userRole'] == 'coach') {
    $dashboardUrl = Url::toRoute('/admin/default/coach-dashboard');;
}
else {
    $dashboardUrl = Url::toRoute('/budget/dashboard');
    $checkSubscription = true;
}

$showEomsSubmitWarning = false;
$showEomsRequiredWarning = false;
if (isset($this->params['showEomsWarning']) && $this->params['showEomsWarning'] && strpos(Yii::$app->request->getPathInfo(), 'budget/end-of-month-summary') !== false) {
    $showEomsSubmitWarning = true;
} elseif (!Yii::$app->session->hasFlash('success') && $eoms && (Yii::$app->session->get('eomsOverdue') || Yii::$app->session->get('forceEoms') || Yii::$app->session->get('showEomsWarning') && strpos(Yii::$app->request->getPathInfo(), 'budget/end-of-month-summary') === false)) {
    $showEomsRequiredWarning = true;
}
$hasFlash = Yii::$app->session->hasFlash('warning') || Yii::$app->session->hasFlash('success') || $showEomsSubmitWarning || $showEomsRequiredWarning;
$wrapClass = $hasFlash ? 'has-flash' : '';
if ($eoms && $eoms->showLockWarning()) {
    $wrapClass .= ' has-flash-extended';
}
$currentSubscription = Yii::$app->session->get('subscription')->getCurrentSubscription();
$daysLeft = null;
if ($currentSubscription && $currentSubscription->userPlanType->getPlanType() == UserPlanType::PLAN_TYPE_BOOTCAMP) {
    $daysLeft = $currentSubscription->getDaysLeft();
}

$this->beginPage(); ?><!DOCTYPE html>
<html lang="en">
    <head>
        <?php if (empty(Yii::$app->params['hideIntercom'])) { ?>
        <script>
            var dataLayer = window.dataLayer = window.dataLayer || [];
            dataLayer.push({
                intercomSettings: {
                    app_id: "eyivdakd"<?php if (!Yii::$app->user->isGuest) { ?>,
                    name: "<?= Yii::$app->user->identity->fullName ?>",
                    email: "<?= Yii::$app->user->identity->email ?>",
                    user_id: "<?= Yii::$app->user->id ?>",
                    created_at: <?= strtotime(Yii::$app->user->identity->created_at) ?>,
                    <?php $userPlan = UserPlan::getActivePlan(Yii::$app->user->id);
                        if ($userPlan) { ?>plan_name: "<?= $userPlan->userPlanVariation->name ?>",<?php } ?>
                    user_hash: "<?= hash_hmac(
                        'sha256',
                        Yii::$app->user->id,
                        Yii::$app->params['intercom_hash']
                    ) ?>"
                    <?php } ?>
                }
                <?php if (empty(Yii::$app->params['hideIntercom']) && !Yii::$app->user->isGuest && Yii::$app->session->get('fts-completed')) { ?>
                , ftsCompleted: '<?= Yii::$app->user->identity->email ?>'
                <?php Yii::$app->session->remove('fts-completed');
                }
                if (!Yii::$app->user->isGuest) { ?>
                , userId: <?= Yii::$app->user->id ?>
                <?php } ?>
            });
        </script>
        <?php } ?>
        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','GTM-KVVB5GB');</script>
        <!-- End Google Tag Manager -->
        <meta content="text/html;charset=UTF-8" http-equiv="content-type">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?> | <?= Yii::$app->name ?></title>
        <link rel="shortcut icon" href="<?= Url::to(['/favicon.ico']) ?>" type="image/x-icon">
        <link rel="icon" href="<?= Url::to(['/favicon.ico']) ?>" type="image/x-icon">
        <?php $this->head() ?>
    </head>
    <body class="app-container<?php if (isset($this->params['showEomsWarning']) && $this->params['showEomsWarning']) echo ' top-warning'; ?>"
          data-subscription-status="<?= Yii::$app->session->get('invalidSubscription') && $checkSubscription ?
              (empty($currentSubscription) ? '-1' : '0') :
              '1' ?>"
          data-no-userdetails="<?= Yii::$app->session->get('noUserDetails') ? '1' : '0' ?>"
          data-base-url="<?= Url::base() ?>" data-date-format="<?= Formatter::getDateFormat(); ?>"
          data-currency-symbol="<?= Formatter::getCurrencySign() ?>">
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KVVB5GB"
                          height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        <?php $this->beginBody(); ?>
        <div class="wrap <?= $wrapClass ?>">

            <!---------------------------------------------------------------
            Top Bar
            ---------------------------------------------------------------->
            <nav id="top-bar" class="container-fluid navbar-fixed-top">
                <div class="wrap">
                    <div id="mobile-toggle">
                        <button id="mobile-nav-toggle" type="button" data-toggle="offcanvas"  data-target="#side-bar"><span class="glyphicon glyphicon-menu-hamburger"></span></button>
                    </div>
                    <div id="logo">
                        <a href="<?= $dashboardUrl ?>" class="system-link"><img class="logo-light" src="<?= Url::to('@web/imgs/logo-light.svg') ?>" onerror="this.src='<?= Url::to('@web/imgs/logo-light.svg') ?>'" alt="Grandmas Jars"></a>
                    </div>
                    <?php if ($this->params['userRole'] != 'superadmin') { ?>
                    <ul id="alert-menu" class="col alert-nav">
                        <li id="notification-alert" class="alert-nav-btn alert-ntf top-bar-dropdown-menu">
                            <button id="ntf-alert-menu" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="menu-btn alert-btn top-bar-btn">
                                <i class="icon-alert gj-2x"></i>
                                <span class="alert-count">
                                    <?= $this->params['notificationsCount'] ?>
                                </span>
                            </button>
                            <div class="dropdown-menu top-bar-dropdown">
                                <ul id="notification-alert-dropdown" role="menu" aria-labelledby="ntf-alert-menu">
                                    <?= UnreadNotifications::widget(['userId' => $this->params['userIdentity']->id]); ?>
                                </ul>
                                <div class="view-all-link">
                                    <a href="<?= Url::toRoute(['/notifications']) ?>" class="btn btn-sm btn-primary">View All</a>
                                </div>
                            </div>
                        </li>
                        <li id="message-alert" class="alert-nav-btn alert-msg top-bar-dropdown-menu">
                            <button id="msg-alert-menu" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="menu-btn alert-btn top-bar-btn">
                                <i class="demo-icon icon-message"></i>
                                <span class="alert-count">
                                    <?= isset($this->params['messagesCount']) ? $this->params['messagesCount'] : 0; ?>
                                </span>
                            </button>
                            <div class="dropdown-menu top-bar-dropdown">
                                <ul id="message-alert-dropdown" role="menu" aria-labelledby="msg-alert-menu">
                                    <?= UnreadConversationMessages::widget(['userId' => $this->params['userIdentity']->id]); ?>
                                </ul>
                                <div class="view-all-link">
                                    <?php if (in_array($this->params['userRole'], ['client', 'sub-client'])) { ?>
                                    <textarea id="menu-new-message" name="messages-input" class="messages-input" placeholder="Enter message here..." data-conversation-id="<?= $this->params['userIdentity']->getMainConversation()->id ?>"></textarea>
                                    <a href="#" class="btn btn-sm btn-success send-message">Send</a>
                                    <a href="<?= Url::toRoute(['/conversations']) ?>" class="btn btn-sm btn-primary" id="msg-view-btn">View All</a>
                                    <?php } else { ?>
                                    <a href="<?= Url::toRoute(['/admin/coach/index']) ?>" class="btn btn-sm btn-primary full-width" id="msg-view-btn">View All</a>
                                    <?php } ?>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </li>
                    </ul>
                    <?php } ?>
                    <div id="search-bar" class="">
                        <form action="<?= Url::to(['/search/results']) ?>" id="search-form">
                        <div class="input-group" role="menu">
                            <input name="q" type="text" class="form-control" placeholder="Need help?" value="<?= Html::encode(Yii::$app->request->getQueryParam('q', '')) ?>" />
                            <span class="input-group-btn">
                                <button class="btn search-trigger disable-default" type="submit"><span class="glyphicon glyphicon-search" aria-hidden="true"></span></button>
                            </span>
                        </div>
                        </form>
                    </div>
                    <div id="profile-menu" class="top-bar-dropdown-menu <?= $daysLeft !== null ? 'show-expire' : '' ?>">
                        <?php if ($daysLeft !== null) { ?>
                        <span class="expire-time"><?= $daysLeft . ' ' . ($daysLeft == 1 ? 'day' : 'days') ?> of free trial left</span>
                        <?php } ?>
                        <a class="profile-image" href="<?= Url::toRoute('/users/index'); ?>">
                            <img class="img-circle" src="<?= Yii::$app->user->identity->getAvatarUrl() ?>" alt="profile picture">
                        </a>
                        <a class="profile-name" href="<?= Url::toRoute('/users/index'); ?>"><?= $this->params['username']; ?></a>
                        <button id="profile-dropdown-toggle" class="top-bar-btn" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="caret"></span></button>
                        <ul id="profile-dropdown-menu" class="dropdown-menu top-bar-dropdown" role="menu" aria-labelledby="profile-dropdown-toggle">
                            <?php if (in_array($this->params['initUserRole'], ['client', 'subClient']) || $adminSelectedUserId) { ?>
                            <li class="view-my-profile"><a href="<?= Url::toRoute(['/users/user-profile']) ?>">View My Profile</a></li>
                            <?php } ?>
                            <li class="account-settings"><a href="<?= Url::toRoute('/users/index'); ?>">Account Settings</a></li>
                            <?php if (in_array($this->params['initUserRole'], ['client']) || $adminSelectedUserId) { ?>
                            <li class="manage-subscriptions"><a href="<?= Url::toRoute('/subscription/index'); ?>">Manage Subscription</a></li>
                            <?php } ?>
                            <li><a href="#" id="bug-report-link" class="skipHistory open-modal" data-modal-url="<?= Url::toRoute(['/support/bugs']) ?>">Give Feedback</a></li>
                            <li><a href="<?= Url::toRoute('/activity-log') ?>" class="system-link">Activity Log</a></li>
                            <li class="view-all-link"><a href="<?= Url::toRoute('/site/logout') ?>" class="skip-history">Log Out</a></li>
                        </ul>
                    </div>
                </div>
                <?php if ($showEomsSubmitWarning) { ?>
                    <div class="eoms-warning">
                        <p><i class="glyphicon glyphicon-alert"></i> You have entered amounts for your monthly summary. Balances for accounts and debts will be overwritten once you have pressed 'Submit Balances' at the bottom of this page.</p>
                    </div>
                <?php } elseif ($showEomsRequiredWarning) { ?>
                    <div class="app-warning">
                        <p class="text-center">
                            <strong>Attention:</strong>
                            <?= $eoms->getWarningText() ?>
                        </p>
                    </div>
                <?php } ?>
                <?php if (Yii::$app->session->hasFlash('warning')) { ?>
                <div class="app-warning">
                    <p class="text-center">
                        <?= Yii::$app->session->getFlash('warning') ?>
                    </p>
                </div>
                <?php } ?>
                <?php if (Yii::$app->session->hasFlash('success')) { ?>
                <div class="app-success autodestroy" data-timeout="10">
                    <p class="text-center">
                        <?= Yii::$app->session->getFlash('success') ?>
                    </p>
                </div>
                <?php } ?>
            </nav>
            <!---------------------------------------------------------------
            End Top Bar
            ---------------------------------------------------------------->


            <!---------------------------------------------------------------
            Primary Navigation
            ---------------------------------------------------------------->
            <div id="content" class="container-fluid canvas-slid">
                <?= $this->render('_main-left-menu', [
                    'userRole' => $this->params['userRole'],
                    'initUserRole' => $this->params['initUserRole'],
                    'adminSelectedUserId' => $adminSelectedUserId,
                    'mockBudgetId' => $this->params['mockBudgetId']
                ]); ?>
                <!---------------------------------------------------------------
                End Primary Navigation
                ---------------------------------------------------------------->

                <!-- content loaded via ajax -->
                <div id="loaded-content"></div>
                <!-- /content loaded via ajax -->

                <div class="modal fade" id="appModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Basic Popup</h4>
                            </div>
                            <div class="modal-body">
                                <form>
                                    <div class="form-group">
                                        <label for="recipient-name" class="control-label">Name</label>
                                        <input type="text" class="form-control" id="recipient-name">
                                    </div>
                                    <div class="form-group">
                                        <label for="message-text" class="control-label">Message:</label>
                                        <textarea class="form-control" id="message-text"></textarea>
                                    </div>
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="button" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- top-screen notification -->
                <div id="top-screen-notification">
                    <p></p>
                    <i class="glyphicon glyphicon-remove"></i>
                </div>
                <!-- /top-screen notification -->
            </div>
        </div>

        <noscript>
            <ul id="noty_topRight_layout_container-static" class="i-am-new" style="top: 20px; right: 20px; position: fixed; width: 310px; height: auto; margin: 0px; padding: 0px; list-style-type: none; z-index: 10000000;"><li style="overflow: hidden; border-radius: 5px; border: 1px solid darkred; box-shadow: rgba(0, 0, 0, 0.0980392) 0px 2px 4px; color: rgb(255, 255, 255); width: 310px; cursor: pointer;background: rgb(255, 0, 0);"><div class="noty_bar noty_type_error" id="noty_1383039824369643000"><div class="noty_message" style="font-size: 13px; line-height: 16px; text-align: left; padding: 8px 10px 9px; width: auto; position: relative; font-weight: bold;">
                            <span class="noty_text">Your JavaScript setting is currently disabled. Please enable JavaScript on your browser and refresh this page.</span>
                        </div></div></li></ul>
        </noscript>
        <?php $this->endBody(); ?>
    </body>
</html>
<?php $this->endPage();
