<?php
use backend\assets\AppAsset;
use backend\models\db\UserPlan;
use kartik\switchinput\SwitchInputAsset;
use yii\helpers\Html;
use yii\helpers\Url;

use backend\components\helpers\Formatter;

AppAsset::register($this);
SwitchInputAsset::register($this);

$this->beginPage(); ?><!DOCTYPE html>
<html lang="en">
    <head>
        <?php if (empty(Yii::$app->params['hideIntercom'])) { ?>
        <script>
            var dataLayer = window.dataLayer = window.dataLayer || [];
            dataLayer.push({
                intercomSettings: {
                    app_id: "eyivdakd"<?php if (!Yii::$app->user->isGuest) { ?>,
                    name: "<?= Yii::$app->user->identity->fullName ?>",
                    email: "<?= Yii::$app->user->identity->email ?>",
                    user_id: "<?= Yii::$app->user->id ?>",
                    created_at: <?= strtotime(Yii::$app->user->identity->created_at) ?>,
                    <?php $userPlan = UserPlan::getActivePlan(Yii::$app->user->id);
                        if ($userPlan) { ?>plan_name: "<?= $userPlan->userPlanVariation->name ?>",<?php } ?>
                    user_hash: "<?= hash_hmac(
                        'sha256',
                        Yii::$app->user->id,
                        Yii::$app->params['intercom_hash']
                    ) ?>"
                    <?php } ?>
                }
                <?php if (!Yii::$app->user->isGuest) { ?>
                , userId: <?= Yii::$app->user->id ?>
                <?php } ?>
            });
        </script>
        <?php } ?>
        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','GTM-KVVB5GB');</script>
        <!-- End Google Tag Manager -->
        <meta content="text/html;charset=UTF-8" http-equiv="content-type">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?> | <?= Yii::$app->name ?></title>
        <link rel="shortcut icon" href="<?= Url::to(['/favicon.ico']) ?>" type="image/x-icon">
        <link rel="icon" href="<?= Url::to(['/favicon.ico']) ?>" type="image/x-icon">
        <?php $this->head() ?>
    </head>
    <body class="app-container minimal-layout"
          data-base-url="<?= Url::base() ?>"
          data-date-format="<?= Formatter::getDateFormat(); ?>"
          data-subscription-status="<?= Yii::$app->session->get('invalidSubscription') ?
              (empty(Yii::$app->session->get('subscription')->getCurrentSubscription()) ? '-1' : '0') :
              '1' ?>"
          data-no-userdetails="<?= Yii::$app->session->get('noUserDetails') ? '1' : '0' ?>"
    >
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KVVB5GB"
                          height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        <?php $this->beginBody(); ?>
        <div class="wrap">

            <!---------------------------------------------------------------
            Top Bar
        ---------------------------------------------------------------->
            <nav id="top-bar" class="container-fluid navbar-fixed-top">
                <div class="wrap">
                    <div id="logo">
                        <a href="<?= Url::to('@web/'); ?>" class="logo-link"><img class="logo-light" src="<?= Url::to('@web/imgs/logo-light.svg') ?>" onerror="this.src='<?= Url::to('@web/imgs/logo-light.svg') ?>'" alt="Grandmas Jars"></a>
                        <?= Html::a('Logout', ['/site/logout'], ['class' => 'pull-right logout-btn']) ?>
                    </div>
                </div>
            </nav>
            <!---------------------------------------------------------------
            End Top Bar
            ---------------------------------------------------------------->

            <!-- content loaded via ajax -->
            <div id="loaded-content"></div>
            <!-- /content loaded via ajax -->

            <footer></footer>

            <div class="modal fade" id="appModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="myModalLabel">Basic Popup</h4>
                        </div>
                        <div class="modal-body">
                            <form>
                                <div class="form-group">
                                    <label for="recipient-name" class="control-label">Name</label>
                                    <input type="text" class="form-control" id="recipient-name">
                                </div>
                                <div class="form-group">
                                    <label for="message-text" class="control-label">Message:</label>
                                    <textarea class="form-control" id="message-text"></textarea>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- top-screen notification -->
            <div id="top-screen-notification">
                <p></p>
                <i class="glyphicon glyphicon-remove"></i>
            </div>
            <!-- /top-screen notification -->
        </div>

        <noscript>
            <ul id="noty_topRight_layout_container-static" class="i-am-new" style="top: 20px; right: 20px; position: fixed; width: 310px; height: auto; margin: 0px; padding: 0px; list-style-type: none; z-index: 10000000;"><li style="overflow: hidden; border-radius: 5px; border: 1px solid darkred; box-shadow: rgba(0, 0, 0, 0.0980392) 0px 2px 4px; color: rgb(255, 255, 255); width: 310px; cursor: pointer;background: rgb(255, 0, 0);"><div class="noty_bar noty_type_error" id="noty_1383039824369643000"><div class="noty_message" style="font-size: 13px; line-height: 16px; text-align: left; padding: 8px 10px 9px; width: auto; position: relative; font-weight: bold;">
                            <span class="noty_text">Your JavaScript setting is currently disabled. Please enable JavaScript on your browser and refresh this page.</span>
                        </div></div></li></ul>
        </noscript>
        <?php $this->endBody(); ?>
    </body>
</html>
<?php $this->endPage();
