<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>
<div role="tabpanel" class="tab-pane active" id="title1" data-js-callback="budgetMockBudgetDetailLoaded" data-select-menu="li#budgeting-tools-mock-budgets" data-income-id="<?= $income->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <div class="col-head">
        <h3><?= $income->name ?></h3>
        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/incomes/edit-income', 'id' => $income->id]) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/incomes/remove-income', 'id' => $income->id]) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
    </div>
    <div class="row">
        <div class="col-sm-5">
            <div class="label-group">
                <label for="frequency">Frequency</label>
                <div class="label-value">
                    <?= Frequencies::getLabel($income->frequency); ?>
                </div>
            </div>
            <div class="label-group">
                <label for="payday" class="control-label">Next Pay Day</label>
                <div class="label-value">
                    <?=  Formatter::date($income->getNextDue()); ?>
                </div>
            </div>
            <div class="label-group has-feedback">
                <label for="amount">Amount</label>
                <div class="label-value">
                    <?= Formatter::currency($income->amount); ?>
                </div>
            </div>
        </div>
    </div>
</div>
