<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>

<div id="body" class="container-fluid" data-js-callback="budgetMockBudgetOverviewLoaded" data-select-menu="li#budgeting-tools-mock-budgets" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $comparedBudgetName ?></h3>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <ol class="breadcrumb">
                <li><a href="<?= Url::toRoute('/mock-budgets')?>" class="system-link"><i class="glyphicon glyphicon-home gi-2x"></i></a></li>
                <li class="active"><?= $comparedBudgetName ?></li>
            </ol>
        </div>
    </div>

    <div class="mock-budget">
        <div class="row">
            <div class="col-sm-6 col-edit">
                <div class="row mt20">
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value"><?= Formatter::currency($comparedAvgMonthlyIncome) ?></div>
                            <div class="desc">Average Monthly Income</div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value"><?= Formatter::currency($comparedTotalMonthlyBudget) ?></div>
                            <div class="desc">Monthly Jar Allocation</div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value<?= $comparedAvgMonthlySurplus > 0 ? ' value-green' : ($comparedAvgMonthlySurplus < 0 ? ' value-red' : '') ?>"><?= Formatter::currency($comparedAvgMonthlySurplus) ?></div>
                            <div class="desc">Average Monthly <?= $comparedAvgMonthlySurplus >= 0 ? 'Surplus' : 'Deficit'; ?></div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value"><?= Formatter::currency($comparedMinMonthlyIncome) ?></div>
                            <div class="desc">Minimum Monthly Income</div>
                        </div>
                    </div>
                    <div class="col-sm-4 col-sm-offset-4">
                        <div class="item-value">
                            <div class="value<?= $comparedMinMonthlySurplus > 0 ? ' value-green' : ($comparedMinMonthlySurplus < 0 ? ' value-red' : '') ?>"><?= Formatter::currency($comparedMinMonthlySurplus) ?></div>
                            <div class="desc">Minimum Monthly <?= $comparedMinMonthlySurplus >= 0 ? 'Surplus' : 'Deficit'; ?></div>
                        </div>
                    </div>
                </div>
                <div class="col-head">
                    <h4>Monthly Income</h4>
                    <?php if ($editable) { ?>
                    <a class="btn btn-primary btn-sm system-link" href="<?= Url::toRoute(['/incomes/index', 'budget_id' => $comparedBudgetId]) ?>">Adjust Mock Income</a>
                    <?php } ?>
                </div>
                <div class="panel panel-table">
                    <?= $this->render('/budget/_monthly-income-table', [
                        'budgetId' => $comparedBudgetId,
                        'minMonthlyIncome'  => $comparedMinMonthlyIncome,
                        'avgMonthlyIncome'  => $comparedAvgMonthlyIncome
                    ]); ?>
                </div>

                <div class="col-head">
                    <h4>Monthly Jar Allocations</h4>
                    <?php if ($editable) { ?>
                    <a class="btn btn-primary btn-sm system-link" href="<?= Url::toRoute(['/jars/index', 'budget_id' => $comparedBudgetId])?>">Adjust Mock Jars</a>
                    <?php } ?>
                </div>
                <div class="panel panel-table">
                    <?= $this->render('/budget/_monthly-jar-allocations',[
                        'budgetId' => $comparedBudgetId,
                        'totalMonthlyBudget' => $comparedTotalMonthlyBudget
                    ]); ?>
                </div>

                <div class="panel panel-tabbed">
                    <div class="tabpanel">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs" role="tablist">
                            <li role="presentation" class="active"><a href="#compared-monthly-income" aria-controls="home" role="tab" data-toggle="tab">Monthly Income</a></li>
                            <li role="presentation"><a href="#compared-jar-allocations" aria-controls="profile" role="tab" data-toggle="tab">Jar Allocations</a></li>
                            <li role="presentation"><a href="#compared-compare" aria-controls="profile" role="tab" data-toggle="tab">Compare Income to Outgoings</a></li>
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane panel-paged data-graph static-graph active" id="compared-monthly-income" data-ajax="<?= Url::toRoute(['/budget/monthly-income-graph-data', 'id' => $comparedBudgetId]) ?>">
                                <div class="ct-chart"></div>
                            </div>
                            <div role="tabpanel" class="tab-pane panel-paged data-graph static-graph" id="compared-jar-allocations" data-ajax="<?= Url::toRoute(['/budget/jar-allocations-graph-data', 'id' => $comparedBudgetId]) ?>">
                                <div class="ct-chart"></div>
                            </div>
                            <div role="tabpanel" class="tab-pane data-graph static-graph panel-paged" id="compared-compare" data-ajax="<?= Url::toRoute(['/budget/compare-graph-data', 'id' => $comparedBudgetId]) ?>">
                                <div class="ct-chart"></div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-sm-6 col-show">
                <div class="row mt20">
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value"><?= Formatter::currency($activeAvgMonthlyIncome) ?></div>
                            <div class="desc">Average Monthly Income</div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value"><?= Formatter::currency($activeTotalMonthlyBudget) ?></div>
                            <div class="desc">Monthly Jar Allocation</div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value<?= $activeAvgMonthlySurplus > 0 ? ' value-green' : ($activeAvgMonthlySurplus < 0 ? ' value-red' : '') ?>"><?= Formatter::currency($activeAvgMonthlySurplus) ?></div>
                            <div class="desc">Average Monthly <?= $activeAvgMonthlySurplus >= 0 ? 'Surplus' : 'Deficit'; ?></div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="item-value">
                            <div class="value"><?= Formatter::currency($activeMinMonthlyIncome) ?></div>
                            <div class="desc">Minimum Monthly Income</div>
                        </div>
                    </div>
                    <div class="col-sm-4 col-sm-offset-4">
                        <div class="item-value">
                            <div class="value<?= $activeMinMonthlySurplus > 0 ? ' value-green' : ($activeMinMonthlySurplus < 0 ? ' value-red' : '') ?>"><?= Formatter::currency($activeMinMonthlySurplus) ?></div>
                            <div class="desc">Minimum Monthly <?= $activeMinMonthlySurplus >= 0 ? 'Surplus' : 'Deficit'; ?></div>
                        </div>
                    </div>
                </div>
                <div class="col-head">
                    <h4>Monthly Income</h4>
                </div>
                <div class="panel panel-table">
                    <?= $this->render('/budget/_monthly-income-table', [
                        'budgetId' => $activeBudgetId,
                        'minMonthlyIncome'  => $activeMinMonthlyIncome,
                        'avgMonthlyIncome'  => $activeAvgMonthlyIncome,
                        'tableId' => 'ami-table-1'
                    ]); ?>
                </div>

                <div class="col-head">
                    <h4>Monthly Jar Allocations</h4>
                </div>
                <div class="panel panel-table">
                    <?= $this->render('/budget/_monthly-jar-allocations',[
                        'budgetId' => $activeBudgetId,
                        'totalMonthlyBudget' => $activeTotalMonthlyBudget,
                        'tableId' => 'aj-table-1'
                    ]); ?>
                </div>

                <div class="panel panel-tabbed">
                    <div class="tabpanel">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs" role="tablist">
                            <li role="presentation" class="active"><a href="#active-monthly-income" aria-controls="home" role="tab" data-toggle="tab">Monthly Income</a></li>
                            <li role="presentation"><a href="#active-jar-allocations" aria-controls="profile" role="tab" data-toggle="tab">Jar Allocations</a></li>
                            <li role="presentation"><a href="#active-compare" aria-controls="profile" role="tab" data-toggle="tab">Compare Income to Outgoings</a></li>
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane data-graph static-graph panel-paged active" id="active-monthly-income" data-ajax="<?= Url::toRoute(['/budget/monthly-income-graph-data', 'id' => $activeBudgetId]) ?>">
                                <div class="ct-chart"></div>
                            </div>
                            <div role="tabpanel" class="tab-pane data-graph static-graph panel-paged" id="active-jar-allocations" data-ajax="<?= Url::toRoute(['/budget/jar-allocations-graph-data', 'id' => $activeBudgetId]) ?>">
                                <div class="ct-chart"></div>
                            </div>
                            <div role="tabpanel" class="tab-pane data-graph static-graph panel-paged" id="active-compare" data-ajax="<?= Url::toRoute(['/budget/compare-graph-data', 'id' => $activeBudgetId]) ?>">
                                <div class="ct-chart"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt20">
            <?= Html::submitButton('Submit to Coach', ['class' => 'btn btn-primary open-modal','data-modal-url' => Url::toRoute(['/mock-budgets/submit-budget', 'id' => $comparedBudgetId]), 'data-js-callback' => 'reloadPage']) ?>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
