<?php
use backend\models\db\Budget;
use backend\widgets\BudgetShortfallCalculator;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
use backend\widgets\VideoTutorial;
?>

<div id="body" class="container-fluid" data-js-callback="budgetMockBudgetsLoaded" data-select-menu="li#budgeting-tools-mock-budgets" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget() ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3>Mock Budgets</h3>
                <a data-modal-url="<?= Url::toRoute(['/mock-budgets/add-budget']) ?>" class="btn btn-primary btn-sm open-modal">
                    <i class="glyphicon glyphicon-plus"></i> Add
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="mock-budgets">
                <?php /** @var Budget $b */
                foreach ($budgets as $key => $b) { ?>
                <div class="panel panel-tabbed<?= ($key == 0) ? ' active' : '' ?>">
                    <div class="clearfix">
                        <?php if ($key != 0) { ?>
                        <a href="<?= Url::toRoute(['/mock-budgets/budget-detail', 'id' => $b->id]) ?>" class="system-link">
                        <?php } else { ?>
                        <a href="#" onclick="return false" class="no-link">
                        <?php } ?>
                            <div class="col-md-1 title">
                                <div><?=$b->name ?></div>
                            </div>
                            <div class="col-md-2">
                                <div class="subtitle">Minimum Monthly Income</div>
                                <div class="val"><?= Formatter::currency($b->getMinimumMonthlyIncomeAmount()) ?></div>
                            </div>
                            <div class="col-md-2">
                                <div class="subtitle">Average Monthly Income</div>
                                <div class="val"><?= Formatter::currency($b->getAverageMonthlyIncomeAmount()) ?></div>
                            </div>
                            <div class="col-md-2">
                                <div class="subtitle">Total Jar Allocation</div>
                                <div class="val"><?= Formatter::currency($b->getTotalMonthlyBudget()) ?></div>
                            </div>
                            <div class="col-md-2">
                                <?php $amount = $b->getMinimumMonthlyIncomeAmount() - $b->getTotalMonthlyBudget(); ?>
                                <div class="subtitle">Minimum Monthly <?= $amount >= 0 ? 'Surplus' : 'Deficit' ?></div>
                                <div class="val"><?= Formatter::currency($amount) ?></div>
                            </div>
                            <div class="col-md-2">
                                <?php $amount = $b->getAverageMonthlyIncomeAmount() - $b->getTotalMonthlyBudget(); ?>
                                <div class="subtitle">Average Monthly <?= $amount >= 0 ? 'Surplus' : 'Deficit' ?></div>
                                <div class="val"><?= Formatter::currency($amount) ?></div>
                            </div>
                        </a>
                        <div class="col-md-1 actions last">
                            <?php if (($key!=0)) { ?>
                            <a href="#" id="menu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"><i class="glyphicon glyphicon-cog gi-2x"></i></a>
                            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="menu1">
                                <?php if ($key!=0) { ?>
                                <li><a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/mock-budgets/edit-budget', 'id' => $b->id]) ?>">Edit</a></li>
                                <li><a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/mock-budgets/switch-budget', 'id' => $b->id]) ?>">Switch to ...</a></li>
                                <?php } ?>
                                <?php if (($key!=0) && ($b->name != 'Default')) { ?>
                                <li><a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/mock-budgets/remove-budget', 'id' => $b->id]) ?>">Remove</a></li>
                                <?php } ?>
                            </ul>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>

        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>

