<?php
use yii\bootstrap\ButtonDropdown;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use backend\widgets\Tooltip;
use backend\widgets\VideoTutorial;
?>

<div id="body" class="container-fluid" data-js-callback="moneyOperationsLoaded" data-select-menu="li#my-jars-transactions" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget(['type' => 'transactions']) ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3>Transactions</h3>
                <div class='transactions-top-buttons row'>
                    <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/transactions/add-es-transaction']) ?>">+ Add Transaction</a>
                    <?= Tooltip::widget(['text' => 'Record spending, receiving, or transfering money.']) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb mt20">
        <div class="col-sm-4">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="mo-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
        <div class="col-sm-4">
            <?= ButtonDropdown::widget([
                'label' => $year,
                'dropdown' => [
                    'items' => $years,
                ],

            ]); ?>
            <?= ButtonDropdown::widget([
                'label' => $monthName,
                'dropdown' => [
                    'items' => $months,
                ]
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 col-md-offset-0 col-xs-11">
            <div class="panel panel-table expenses-panel onetime-expenses money-operations-table">
                <?= $this->render('/money-operations/_money-operations-table', [
                    'moneyOperationsAmount' => $moneyOperationsAmount,
                    'year' => $year,
                    'month' => $month
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
