<?php
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\widgets\Messages;


/* @var $this yii\web\View */
/* @var $formModel \common\models\form\Register */

$this->params['breadcrumbs'][] = $title;
?>
<div class="site-login">
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <h3 class="text-center mb40"><?= Html::encode($title) ?></h3>
            <?= Messages::widget(['name' => 'registration']); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4 col-md-offset-4">
            <?php $form = ActiveForm::begin(['id' => 'register-form']); ?>
                <?= $form->field($formModel, 'username') ?>
                <?= $form->field($formModel, 'email') ?>
                <?= $form->field($formModel, 'password')->passwordInput() ?>
                <?= $form->field($formModel, 'password_repeat')->passwordInput() ?>
                <div class="form-group text-center">
                    <?= Html::submitButton('Register', ['class' => 'btn btn-primary', 'name' => 'register-button', 'id' => 'register-button']) ?>
                </div>
            <?php ActiveForm::end(); ?>

            <hr style="margin: 10px 0 15px" />

            <p class="text-center">
                Already have an account? <a href="/site/login"><strong>Log in</strong></a>
            </p>

            <?php $this->registerJs(<<<JS
    var dataLayer = window.dataLayer = window.dataLayer || [];
    dataLayer.push({
        trackEvent: 'Lead',
        salevalue: 0.00,
        saleCurrency: 'AUD'
    });
    $('body').on('click', '#register-button', function() {
        var dataLayer = window.dataLayer = window.dataLayer || [];
        dataLayer.push({
            trackEvent: 'AddToCart',
            salevalue: 0.00,
            saleCurrency: 'AUD',
            saleContentIds: ['{$plan->id}'],
            saleContentType: '{$plan->name}'
        });
        return true;
    });
JS
); ?>
        </div>
    </div>
</div>
