<?php
use backend\components\StripeCheckoutExtended;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\widgets\Messages;
use yii\helpers\Url;
use yii\web\JsExpression;

/* @var $this yii\web\View */
/* @var $title string */
/* @var $subtitle string */
/* @var $formModel \common\models\form\Register */
/* @var $plan \backend\models\db\UserPlanType */
/* @var $variations \backend\models\db\UserPlanVariation[] */

$this->params['breadcrumbs'][] = $title;
$variations = $plan->getUserPlanVariations()->all();
$defaultVariation = $plan->getDefaultPlanVariation();
$formModel->plan_variation_id = $variations[0]->id;

$taxPercent = Yii::$app->formatter->asDecimal(Yii::$app->params['gstTaxPercent'] / 100, 2);
?>
<div class="site-login">
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <h3 class="text-center mb40"><?= Html::encode($title) ?></h3>
            <?php if ($hasTrial) { ?>
            <div class="form-group text-center bigger">
                Don't worry, you can easily cancel anytime before that,<br/>
                and your card won't be billed until the trial is over.
            </div>
            <?php } elseif ($subtitle) { ?>
            <div class="form-group text-center bigger">
                <?= $subtitle ?>
            </div>
            <?php } elseif ($plan->description) { ?>
            <div class="form-group text-center bigger">
                <?= $plan->description ?>
            </div>
            <?php } ?>

            <?= Html::hiddenInput('tax_percent', $taxPercent, ['id' => 'tax_percent']) // FIXME: dynamic tax retrieval ?>
            <?= Html::hiddenInput('coupon_url', Url::toRoute(['/register/coupon']), ['id' => 'coupon_url']); ?>

            <?php $form = ActiveForm::begin([
                'id' => 'buy-form',
                'enableAjaxValidation' => true
            ]); ?>
            <div class="registration-section <?= !Yii::$app->session->hasFlash('registration') ? 'active' : '' ?>">
                <div class="section-title">
                    <h4>
                        1. Create your account
                        <span class="open-close plus">+</span>
                    </h4>
                </div>
                <div class="section-body mb20">
                    <?= $form->field($formModel, 'username') ?>
                    <?= $form->field($formModel, 'email') ?>
                    <?= $form->field($formModel, 'password')->passwordInput() ?>
                    <?= $form->field($formModel, 'password_repeat')->passwordInput() ?>
                </div>
            </div>
            <div class="registration-section <?= Yii::$app->session->hasFlash('registration') ? 'active' : '' ?>">
                <div class="section-title">
                    <h4>
                        2. Payment options
                        <span class="open-close plus">+</span>
                    </h4>
                </div>
                <div class="section-body">
                    <div class="price-options">
                        <?php if (count($variations) > 1) { ?>
                        <div class="price-option selected"
                             data-id="<?= $variations[1]->id ?>"
                             data-name="<?= $variations[1]->name ?>"
                             data-price-original="<?= $variations[1]->getPrice() * 100 ?>"
                             data-price="<?= $variations[1]->getPrice() * 100 ?>"
                             data-option="<?= $variations[1]->getCleanName() ?>">
                            <p><?= $variations[1]->getCleanName() ?> Payment</p>
                            <h3 class="text-center mb40 variation-1 variation-option">
                                <?= $variations[1]->getPriceText(true, false) ?>
                            </h3>
                            <p>+ GST</p>
                        </div>
                        <div class="price-option"
                             data-id="<?= $variations[0]->id ?>"
                             data-name="<?= $variations[0]->name ?>"
                             data-price-original="<?= $variations[0]->getPrice() * 100 ?>"
                             data-price="<?= $variations[0]->getPrice() * 100 ?>"
                             data-option="<?= $variations[0]->getCleanName() ?>">
                            <p><?= $variations[0]->getCleanName() ?> Payment</p>
                            <h3 class="text-center mb40 variation-0 variation-option">
                                <?= $variations[0]->getPriceText(true, false) ?>
                            </h3>
                            <p>+ GST</p>
                        </div>
                        <?php } else { ?>
                        <div class="price-option selected"
                             data-id="<?= $variations[0]->id ?>"
                             data-name="<?= $variations[0]->name ?>"
                             data-price-original="<?= $variations[0]->getPrice() * 100 ?>"
                             data-price="<?= $variations[0]->getPrice() * 100 ?>"
                             data-option="<?= $variations[0]->getCleanName() ?>">
                            <p><?= $variations[0]->getCleanName() ?> Payment</p>
                            <h3 class="text-center mb40 variation-0 variation-option">
                                <?= $variations[0]->getPriceText(true, false) ?>
                            </h3>
                            <p>+ GST</p>
                        </div>
                        <?php } ?>
                    </div>
                    <!-- <p class="text-center lead mb40">
                        <?= $plan->description ?>
                    </p> -->

                    <?= $form->field($formModel, 'token', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
                    <?= $form->field($formModel, 'plan_variation_id', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
                    <?php if (!isset($noCoupon) || !$noCoupon) {
                        echo $form->field($formModel, 'coupon')->label('Coupon Code');
                    } ?>
                    <?= $form->field($formModel, 'first_name') ?>
                    <?= $form->field($formModel, 'last_name') ?>
                    <?= $form->field($formModel, 'address') ?>

                    <div class="form-group">
                        <label class="control-label" for="card-element">Credit or debit card details</label>
                        <div id="card-element">
                            <!-- a Stripe Element will be inserted here. -->
                        </div>
                        <div id="card-errors" class="text-danger text-center" role="alert"></div>
                    </div>
                </div>
            </div>

            <?= Messages::widget(['name' => 'registration']); ?>

            <div class="mt20 mb20 text-center price-summary bigger" style="display:none">
                <?php if ($hasTrial) { ?>
                After your free trial, you will be billed <strong id="calculated-price"></strong><br/>
                starting on <strong><?= date('F j, Y', strtotime('+30 days')) ?></strong>.
                <?php } else {
                    $billingMonths = $defaultVariation->getBillingMonths(); ?>
                You will be billed <strong id="calculated-price"></strong> <?= $billingMonths ? "for {$billingMonths} months" : '' ?>
                    <?php if ($defaultVariation->upfront_payment) { ?>
                    <br/>with an <strong>upfront payment</strong> of <strong>$<?php
                    echo Yii::$app->formatter->asDecimal($defaultVariation->upfront_payment + $defaultVariation->upfront_payment * $taxPercent, 2); ?></strong>.
                    <?php } elseif (!empty($defaultVariation->stripe_plan_id)) { ?>starting <strong>today</strong>.<?php } ?>
                <?php } ?>
            </div>

            <div class="form-group text-center">
                <?php
                echo Html::button(
                    $defaultVariation->getPrice() > 0 ? ($hasTrial ? 'Start your free trial' : 'Buy') : 'Register',
                    [
                        'class' => 'btn btn-primary',
                        'id' => 'buy-button'
                    ]
                );
                /*echo StripeCheckoutExtended::widget([
                    'id' => 'payInvoice' . $invoice->id,
                    'name' => 'Grandma\'s Jars',
                    'label' => $hasTrial ? 'Start your free trial' : 'Buy',
                    'description' => 'Pay for ' . $plan->name,
                    'amount' => new JsExpression('parseInt($(".price-option.selected").attr("data-price")) + parseInt($(".price-option.selected").attr("data-price")) * $("#tax_percent").val()'),
                    'currency' => Yii::$app->params['defaultChargeCurrency'],
                    'userEmail' => new JsExpression('$("#buy-form #register-email").val()'),
                    'image' => Url::to(['/imgs/jar.png']),
                    'buttonOptions' => [
                        'class' => 'btn btn-primary hidden',
                        'id' => 'stripe-buy'
                    ],
                    'tokenFunction' => new JsExpression("function(token) { submitFormWithToken(token); }"),
                    'openedFunction' => new JsExpression('function() {}'),
                    'closedFunction' => new JsExpression('function() {}')
                ]);*/ ?>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
    <?php
    $stripeKey = Yii::$app->stripe->publicKey;

    $this->registerJsFile('//js.stripe.com/v3/');
    $this->registerJs(<<<JS
    var stripe = Stripe('{$stripeKey}');
    var elements = stripe.elements();
    var style = {
        base: {
            fontSize: '16px',
            color: '#32325d'
        }
    };
    var card = elements.create('card', { hidePostalCode: true, style: style });
    card.mount('#card-element');
    card.addEventListener('change', function(event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });
    
    var planPrice = (parseInt($(".price-option.selected").attr("data-price")) / 100).toFixed(2);
    var dataLayer = window.dataLayer = window.dataLayer || [];
    dataLayer.push({
        trackEvent: 'Lead',
        salevalue: planPrice,
        saleCurrency: 'AUD'
    });
    showCalculatedPrice();
    
    if ($('#buy-form .messages').length > 0) {
        $('#buy-form .registration-section:nth-child(2) .section-title').trigger('click');
    }
    
    function submitFormWithToken(token) {
        if (token.object == 'token') {
            $('.site-login').blockloader();
            $('#buy-form #register-token').val(token.id);
            $('#buy-form').submit();
        }
    }
    function showCalculatedPrice() {
        $('#calculated-price')
            .html('$' + Number(Math.round(
                    (parseInt($(".price-option.selected").attr("data-price")) / 100 +
                    parseInt($(".price-option.selected").attr("data-price")) / 100 * $("#tax_percent").val()) + 'e2'
                ) + 'e-2') +
                ($(".price-option.selected").attr("data-option").length > 0 ?
                    '/' + $(".price-option.selected").attr("data-option") : '')
            );
        $('.price-summary').show();
    }
    var clicked = false;
    $('body').on('click', '.registration-section .section-title', function() {
        var section = $(this).parent();
        section.siblings().find('.section-body').slideUp(function() {
            $(this).parent().removeClass('active');
        });
        section.find('.section-body').slideDown(function() {
            section.addClass('active');
        });
    });
    $('body').on('click', '.registration-section .price-option', function() {
        $('.price-options .price-option').removeClass('selected');
        var option = $(this);
        option.addClass('selected');
        $('#register-plan_variation_id').val(option.data('id'));
        showCalculatedPrice();
    });
    $('body').on('click', '#buy-button', function() {
        $('#buy-form input:not([type=hidden])').each(function() {
            $('#buy-form').yiiActiveForm('validateAttribute', $(this).attr('id'));
        });
        setTimeout(function() {
            if ($('#buy-form').find('.has-error').length > 0) {
                $('.registration-section').each(function() {
                    if ($(this).find('.has-error').length > 0) {
                        $(this).find('.section-title').trigger('click');
                        return false;
                    }
                });
                return false;
            }
        }, 500);
        clicked = true;
        return false;
    });
    $('body').on('change', '#register-coupon', function() {
        $('#buy-button').attr('disabled', true);
        $.post(
            $('#coupon_url').val(),
            { id: $('#register-coupon').val() },
            function (data) {
                if (data.success) {
                    if (data.amount) {
                        $(".price-option.selected").attr("data-price", $(".price-option.selected").attr("data-price-original") - data.amount);
                    }
                    else {
                        $(".price-option.selected").attr("data-price", $(".price-option.selected").attr("data-price-original") -
                            $(".price-option.selected").attr("data-price-original") * data.percent);
                    }
                }
                else {
                    $(".price-option.selected").attr("data-price", $(".price-option.selected").attr("data-price-original"));
                }
                showCalculatedPrice();
                $('#buy-button').attr('disabled', false);
            }, 'json'
        );
    });
    $('body').on('ajaxComplete', '#buy-form', function() {
        if ($(this).find('.has-error').length > 0) {
            clicked = false;
            return false;
        }
        var empty = $('#buy-form .required input:not([type=hidden])').filter(function() { return $(this).val() == '' });
        if ((empty.length == 0 && clicked && $('#buy-form #register-token').val() == '') || $('#buy-form .messages').length > 0) {
            clicked = false;
            var dataLayer = window.dataLayer = window.dataLayer || [];
            dataLayer.push({
                trackEvent: 'AddToCart',
                salevalue: planPrice,
                saleCurrency: 'AUD',
                saleContentIds: [$(".price-option.selected").attr("data-id")],
                saleContentType: $(".price-option.selected").attr("data-name")
            });
            // the form is validated and can be submitted now
            var cardData = {
                name: $("#buy-form #register-first_name").val() + ' ' + $("#buy-form #register-last_name").val(),
                address_line1: $("#buy-form #register-address").val(),
                currency: 'aud'
            };
            stripe.createToken(card, cardData).then(function(result) {
                if (result.error) {
                  // Inform the customer that there was an error
                  $('#card-errors').text(result.error.message);
                } else {
                  // Send the token to your server
                  submitFormWithToken(result.token);
                }
            });
        }
        return false;
    });
JS
); ?>
</div>
