<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use yii\bootstrap\ButtonDropdown;
use backend\widgets\VideoTutorial;
?>
<div id="body" class="container-fluid secondary-nav" data-js-callback="reportDetailLoaded" data-report-id="<?= $reportId ?>" data-select-menu="li#mainnav-reports" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget() ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $this->title ?></h3>
                <?= ButtonDropdown::widget([
                    'label' => $year,
                    'dropdown' => [
                        'items' => $years,
                    ]
                ]); ?>
                <?= ButtonDropdown::widget([
                    'label' => $optionName,
                    'dropdown' => [
                        'items' => $options,
                    ]
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <?php if (!$optionId) { ?>
        <div class="col-md-6">
            <div class="item-value">
                <div class="value"><?= $totalAmount ? Formatter::currency($totalAmount) : '-'; ?></div>
                <div class="desc">Total Balance</div>
            </div>
        </div>
        <div class="col-md-3 col-md-offset-3 text-right">
            <a href="javascript:window.print()" target="_blank" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print Report</a>
        </div>
        <?php } else { ?>
        <div class="col-md-3 col-md-offset-9 text-right">
            <a href="javascript:window.print()" target="_blank" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print Report</a>
        </div>
        <?php } ?>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <?php if ($lastEoms) { ?>
            <div class="panel">
                <?php

                if (!$optionId) {

                    echo $this->render('/budget/_end-of-month-summary-balances-graph', [
                        'year' => $year
                    ]);

                }
                elseif ($optionId == 1) {

                    echo $this->render('/budget/_end-of-month-summary-balances-with-previous-years-graph.php');

                }
                ?>
            </div>
            <?php } else { ?>
            <p>No End of Month Summary yet.</p>
            <?php } ?>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
