<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use yii\bootstrap\ButtonDropdown;
use backend\widgets\VideoTutorial;
?>
<div id="body" class="container-fluid secondary-nav" data-js-callback="reportDetailLoaded" data-report-id="<?= $reportId ?>" data-select-menu="li#mainnav-reports" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget() ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $this->title ?></h3>
                <?= ButtonDropdown::widget([
                    'label' => $year,
                    'dropdown' => [
                        'items' => $years,
                    ]
                ]); ?>
                <?= ButtonDropdown::widget([
                    'label' => $jarName,
                    'dropdown' => [
                        'items' => $allJars,
                    ]
                ]); ?>
                <?php if ($jarId) {
                    echo ButtonDropdown::widget([
                        'label' => $optionName,
                        'dropdown' => [
                            'items' => $options,
                        ]
                    ]);
                } ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="item-value">
                <div class="value"><?= $totalAmount ? Formatter::currency($totalAmount) : '-'; ?></div>
                <div class="desc">Total Amount</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="item-value">
                <div class="value"><?= $averageAmount ? Formatter::currency($averageAmount) : '-'; ?></div>
                <div class="desc">Average Amount</div>
            </div>
        </div>
        <div class="col-md-3 col-md-offset-1 text-right">
            <a href="javascript:window.print()" target="_blank" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print Report</a>
        </div>
    </div>

    <?php if ($jarId) { ?>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table transactions-panel">
            <?php if ($optionId == 1) {
                echo $this->render('/transactions/_transaction-totals-by-jar-for-year-with-previous-years-graph.php', [
                    'jarId' => $jarId
                ]);
            }
            elseif ($optionId == 2) {
                echo $this->render('/transactions/_transaction-totals-by-jar-for-year-with-planned-graph.php', [
                    'year' => $year,
                    'jarId' => $jarId
                ]);
            }
            elseif ($optionId == 3) {
                echo $this->render('/transactions/_transaction-totals-by-jar-for-year-graph.php', [
                    'year' => $year,
                    'jarId' => $jarId
                ]);
                echo $this->render('/transactions/_transaction-totals-by-jar-for-year-chart.php', [
                    'year' => $year,
                    'jarId' => $jarId
                ]);
            } ?>
            </div>
        </div>
    </div>
    <?php } else { ?>
    <div class="row">
        <div class="col-md-12">
            <p>Please select a jar from the list above.</p>
        </div>
    </div>
    <?php } ?>

    <?= $this->render('/layouts/_footer') ?>

</div>


