<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use yii\bootstrap\ButtonDropdown;
use backend\widgets\VideoTutorial;
?>
<div id="body" class="container-fluid secondary-nav" data-js-callback="reportDetailLoaded" data-report-id="<?= $reportId ?>" data-select-menu="li#mainnav-reports" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget() ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $this->title ?></h3>
                <?= ButtonDropdown::widget([
                    'label' => $year,
                    'dropdown' => [
                        'items' => $years,
                    ]
                ]); ?>
                <?= ButtonDropdown::widget([
                    'label' => $jarName,
                    'dropdown' => [
                        'items' => $allJars,
                    ]
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 col-md-offset-9 text-right">
            <a href="javascript:window.print()" target="_blank" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print Report</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <h4>Expenses</h4>
            <div class="panel panel-table transactions-panel">
                <?= $this->render('/transactions/_transactions-by-expense-for-year-chart.php', [
                    'year' => $year,
                    'jarId' => $jarId
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>


