<?php
use yii\helpers\Html;
use yii\widgets\ListView;

/**
 */
?>
<div class="content-container" data-block-loading="true">
    <div id="body" class="container-fluid">
        <div class="col-head">
            <h3>Search Results</h3>
        </div>

        <div class="search-results">
            <?php if($displayResults): ?>
            <div class="row">
                <div class="col-md-4">
                    <?= ListView::widget([
                        'dataProvider' => $faqs,
                        'itemView' => '_faqs',
                        'layout' => "{summary}<div class=\"panel panel-tabbed\">\n{items}\n</div><div class=\"text-center\">{pager}</div>",
                        'pager' => [
                            'maxButtonCount' => 5
                        ],
                        'itemOptions' => [
                            'tag' => false,
                        ],
                        'options' => [
                            'id' => 'faq-list-view',
                            'class' => 'list-view'
                        ]
                    ]) ?>
                </div>
            </div>
            <p class="ask-community"><?= Html::a('Ask our wonderful community', 'https://community.grandmasjars.com/categories/faq', ['target' => '_blank']); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
