<?php
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\widgets\Messages;

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \common\models\LoginForm */

$this->params['breadcrumbs'][] = $title;
?>
<div class="site-login">
    <h1><?= Html::encode($title) ?></h1>

    <p>Please fill out one of the following fields to reset your password:</p>

    <?= Messages::widget(['name' => 'forgotten-password']); ?>

    <?php $form = ActiveForm::begin(['id' => 'forgotten-password-form']); ?>
    <div class="row">
        <div class="col-lg-3">
            <?= $form->field($formModel, 'email') ?>
            <div class="form-group">
                <?= Html::submitButton('Reset', ['class' => 'btn btn-primary', 'name' => 'login-button']) ?>
            </div>
        </div>
        <div class="col-lg-1 text-center">
            <label>&nbsp;</label>
            <h5>OR</h5>
        </div>
        <div class="col-lg-3">
            <?= $form->field($formModel, 'username') ?>
        </div>
    </div>
    <?php ActiveForm::end(); ?>
</div>
