<?php
use backend\models\db\UserPlan;
use backend\widgets\Tooltip;
use kartik\switchinput\SwitchInput;
use ruskid\stripe\StripeCheckoutCustom;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\JsExpression;


/* @var $planFeatures array with features generals to all plans */
/* @var $plansDetails array with details (features) of each plan */
/* @var $userPlan UserPlan model of last plan of User */
?>
<div class="col-sm-<?= $userPlan ? '9' : '12' ?>">
    <table class="plans">
        <thead>
        <tr>
            <th class="col-legend"></th>
            <th colspan="<?= count($plansDetails) ?>">
                <div class="col-head">
                    <h3>Available Plans</h3>
                </div>
            </th>
        </tr>
        <tr>
            <th class="col-legend"></th>
            <?php
            foreach ($plansDetails as $key => $plan) {
                $class_name_plan = "plan" . strval($key + 1);
                ?>
                <th class="plan-type <?= $class_name_plan ?>"><?= $plan->name ?></th>
                <?php
            }
            ?>
        </tr>
        <tr>
            <th class="col-legend">Features</th>
            <?php foreach ($plansDetails as $plan) {
                $variations = $plan->getUserPlanVariations()->all(); ?>
                <th class="price">
                    <?php if (count($variations) > 1) { ?>
                    <div class="variation-0 variation-option variation-option-<?= $plan->id ?>" data-id="<?= $variations[0]->id ?>" data-price="<?= $variations[0]->getPrice() * 100 ?>">
                        <?= $variations[0]->getPriceText(true) ?>
                    </div>
                    <div class="variation-1 variation-option hidden variation-option-<?= $plan->id ?>" data-id="<?= $variations[1]->id ?>" data-price="<?= $variations[1]->getPrice() * 100 ?>">
                        <?= $variations[1]->getPriceText(true) ?>
                    </div>
                    <div class="text-center mb20">
                        <?php if (!$conquerPlan) { ?>
                            <?= SwitchInput::widget([
                                'name' => 'variation',
                                'options' => ['class' => 'register-variation'],
                                'pluginOptions' => [
                                    'offText' => substr($variations[0]->getCleanName(), 0, 1),
                                    'onText' => substr($variations[1]->getCleanName(), 0, 1)
                                ]
                            ]) ?>
                        <?php } ?>
                    </div>
                    <?php } else { ?>
                    <div class="variation-0 variation-option variation-option-<?= $plan->id ?>" data-id="<?= $variations[0]->id ?>" data-price="<?= $variations[0]->getPrice() * 100 ?>">
                        <?= $variations[0]->getPriceText(true) ?>
                    </div>
                    <?php } ?>
                </th>
            <?php } ?>
        </tr>
        </thead>
        <tbody>
        <?php
        foreach ($planFeatures as $feature) {
            ?>
            <tr>
                <td class="col-legend"><?= $feature['name'] ?></td>
                <?php
                foreach ($plansDetails as $key => $plan) {
                    $td_ico_print = true;
                    $class_name_plan = null;

                    foreach ($plan->userPlanDetails as $detail) {
                        if ($detail->user_plan_feature_id == $feature['id']) {
                            if ($detail->archived == '0') {
                                if (is_null($detail->value)) {
                                    $class_name_plan = "plan" . strval($key + 1);
                                } else {
                                    $td_ico_print = false;
                                    ?>
                                    <td><?= $detail->value ?></td>
                                    <?php
                                }
                            }

                            break;
                        }
                    }

                    if ($td_ico_print) {
                        ?>
                        <td><i class="ico ico-check <?= $class_name_plan ?>"></i></td>
                        <?php
                    }
                }
                ?>
            </tr>
            <?php
        }
        ?>
        </tbody>
        <tfoot>
        <tr>
            <td class="col-legend"></td>
                <?php foreach ($plansDetails as $key => $plan) { ?>
                <td class="plan<?= strval($key + 1) ?>">
                    <?php if (!$conquerPlan) { ?>
                    <?= Html::beginForm(['subscription/invoice']) ?>
                    <?= StripeCheckoutCustom::widget([
                        'id' => 'changePlan' . $plan->id,
                        'name' => 'Grandma\'s Jars',
                        'label' => 'CHOOSE THIS PLAN',
                        'description' => 'Change Plan to ' . $plan->name,
                        'amount' => new JsExpression('$(".variation-option-' . $plan->id . ':visible").data("price")'),
                        'currency' => Yii::$app->params['defaultChargeCurrency'],
                        'userEmail' => Yii::$app->user->identity->email,
                        'image' => Url::to(['/imgs/jar.png']),
                        'buttonOptions' => [
                            'class' => 'btn btn-sm',
                        ],
                        'tokenFunction' => new JsExpression("function(token){ processToken($('.variation-option-{$plan->id}:visible').data('id'), token); }"),
                        'openedFunction' => new JsExpression('function() {console.log("Modal opened");}'),
                        'closedFunction' => new JsExpression('function() {console.log("Modal closed");}'),
                    ]); ?>
                    <?= Tooltip::widget(['text' => $plan->description, 'class' => 'plan' . strval($key + 1)]); ?>
                    <?= Html::endForm() ?>
                    <?php } ?>
                </td>
            <?php }

            if (!$conquerPlan) {
                $processUrl = Url::to(['subscription/change', 'id' => '']);
                $this->registerJs(<<<JS
    $('body').on('switchChange.bootstrapSwitch', '.register-variation', function(e) {
        if ($(e.target).is(':checked')) {
            $(this).parents('.price').find('.variation-option').addClass('hidden');
            $(this).parents('.price').find('.variation-option.variation-1').removeClass('hidden');
        }
        else {
            $(this).parents('.price').find('.variation-option').addClass('hidden');
            $(this).parents('.price').find('.variation-option.variation-0').removeClass('hidden');
        }
    });
    var processToken = function(id, token) {
        showLoadingAfterPayment();
        $.post('{$processUrl}' + id + '&token=' + token.id)
            .done(function(data){
                if (data.status == 'error') {
                    hideLoadingAfterPayment();
                    topScreenNotification(data.message, 'error');
                }
                else {
                    window.location.replace('/subscription/index');
                }
            });
        };
JS
                );
            } ?>
        </tr>
        </tfoot>
    </table>
</div>
<?= \backend\components\helpers\JsTools::viewJs($this)?>