<?php use yii\helpers\Url; ?>
<div class="invoice container-fluid">
    <div class="row">
        <div class="col-xs-5">
            <img src="data:image/png;base64,<?= base64_encode(file_get_contents(Yii::getAlias('@webroot/imgs/logo-dark.png'))) ?>" alt="Grandma's Jars" id="logo" />
        </div>
        <div class="col-xs-2 pull-right">
            <p>
                <strong>Invoice Number:</strong><br/>
                #<?= $invoice->id ?>
            </p>
        </div>
        <div class="col-xs-2 pull-right">
            <p>
                <strong>Bill Date:</strong><br/>
                <?= Yii::$app->formatter->asDate($invoice->bill_date) ?>
            </p>
        </div>
    </div>
    <p>&nbsp;</p>
    <div class="row">
        <div class="col-xs-3">
            <p>
                PO Box 4002<br/>
                Hawker<br/>
                2614, ACT<br/>
                Australia
            </p>
        </div>
        <div class="col-xs-4 text-center">
            <?= !$invoice->isPaid ? '<h3 class="unpaid">UNPAID</h3>' : '' ?>
        </div>
        <div class="col-xs-3 pull-right">
            <p>
                <strong>Bill to:</strong><br/>
                <?= $invoice->bill_name ?><br/>
                <?= implode('<br/>', $invoice->getAddressLines(true)) ?>
            </p>
        </div>
    </div>
    <p>&nbsp;</p>
    <table class="table">
        <thead>
        <tr>
            <th>Date</th>
            <th>Description</th>
            <th>Amount</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($invoice->invoiceItems as $item) :?>
            <tr>
                <td>
                    <?= Yii::$app->formatter->asDate($item->date_start) ?> -
                    <?= Yii::$app->formatter->asDate($item->date_end) ?>
                </td>
                <td><?= $item->description ?></td>
                <td><?= Yii::$app->formatter->asCurrency($item->amount) ?></td>
            </tr>
        <?php endforeach ?>
        </tbody>
        <tfoot>
        <?php if (!empty($invoice->percent_off)) { ?>
        <tr>
            <td colspan="2">Discount Percent</td>
            <td><?= Yii::$app->formatter->asDecimal($invoice->percent_off, 1) ?>%</td>
        </tr>
        <?php } ?>
        <?php if (!empty($invoice->amount_off)) { ?>
        <tr>
            <td colspan="2">Discount Amount</td>
            <td><?= Yii::$app->formatter->asCurrency(-1 * $invoice->amount_off) ?></td>
        </tr>
        <?php } ?>
        <?php if (!empty($invoice->tax)) { ?>
        <tr>
            <td colspan="2">Tax<?= $invoice->tax_percent ? ' ('.Yii::$app->formatter->asDecimal($invoice->tax_percent, 1).'%)' : '' ?></td>
            <td><?= Yii::$app->formatter->asCurrency($invoice->tax) ?></td>
        </tr>
        <?php } ?>
        <tr>
            <td colspan="2">Total</td>
            <td><?= Yii::$app->formatter->asCurrency($invoice->total) ?></td>
        </tr>
        </tfoot>
    </table>
</div>
