<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\models\db\FaqQuestion;
use backend\models\db\FaqCategory;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;

/**
 * @var yii\web\View $this
 * @var \backend\models\db\FaqCategory[] $categories
 * @var \backend\models\db\User $user
 */
$categories = FaqCategory::find()->all();
if (count($categories) == 0) {
    $class = new stdClass();
    $class->name = 'Account';
    $class->description = 'Account Creation Description';
    $classFaq = new stdClass();
    $classFaq->id = 1;
    $classFaq->title = 'How do I create a new expense?';
    $classFaq->description = 'Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.';
    $class->faqQuestions = array(
        $classFaq,
        $classFaq,
        $classFaq
    );
    $categories = array(
        $class,
        $class,
        $class,
        $class
    );
}

?>
    <div id="body" class="container-fluid" data-select-menu="li#support-main" data-js-callback="supportMainLoaded"
         data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
        <div class="row">
            <div class="col-sm-4 col-xs-12 text-center">
                <img src="<?= Url::to('@web/imgs/support.png') ?>" />
            </div>
            <div class="col-sm-8">
                <div class="col-head">
                    <h4>Welcome to the Support Page</h4>
                </div>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>
                <p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur</p>
                <div class="mt20 clearfix">
                    <a href="#" class="btn btn-success">Visit Our Support Forums</a>
                    <a href="#" class="btn btn-primary ml">Request Help From Our Support Team</a>
                </div>
            </div>
        </div>
        <div class="row mt20">
            <div class="col-sm-12">
                <h4>Open Support Tickets</h4>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="panel panel-tabbed">
                    <div class="tabpanel tabpanel-secondary support-ticket-tab">
                        <div class="container-fluid">
                            <div class="row no-gutter">
                                <div class="col-lg-6 no-float tab-col">
                                    <ul class="nav nav-tabs detail-tab-nav" role="tablist">
                                        <li role="presentation" class="icon-mobile">
                                            <a href="#">
                                                <span class="support-ticket-status pull-right">Pending</span>
                                                Cant log in with mobile
                                                <span class="clearfix val">
                                                    <span class="pull-left">Ticket: 134235</span>
                                                    <span class="pull-right">20<sup>th</sup> May 2015</span>
                                                </span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-lg-6 no-float">
                                    <!-- Tab panes -->
                                    <div class="tab-content body-content support-ticket-content" data-block-loading="true">
                                        <div role="tabpanel" class="tab-pane active">
                                            <div class="support-ticket-info">
                                                <strong class="support-ticket-title">
                                                    <span class="support-ticket-status pull-right">Pending</span>
                                                    Cant log in with mobile
                                                </strong>
                                                <span class="clearfix val">
                                                    <span class="pull-left">Ticket: 134235</span>
                                                    <span class="pull-right">20<sup>th</sup> May 2015</span>
                                                </span>
                                            </div>
                                            <div class="support-ticket-details">
                                                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
                                                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo</p>
                                            </div>
                                            <div class="support-ticket-messages messages">
                                                <div class="item clearfix">
                                                    <div class="avatar">
                                                        <img src="<?= Url::to('@web/imgs/profile.jpg') ?>" alt="">
                                                    </div>
                                                    <div class="text">
                                                        <div class="clearfix">
                                                            <div class="user">
                                                                Daniel J <span class="label label-primary">Support</span>
                                                            </div>
                                                            <div class="message-date">November 13, 2015 at 4:51:51 PM GMT+1</div>
                                                        </div>
                                                        <p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
                                                        <p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?</p>
                                                    </div>
                                                </div>
                                                <div class="item alternative clearfix">
                                                    <div class="avatar">
                                                        <img src="<?= Url::to('@web/imgs/profile.jpg') ?>" alt="">
                                                    </div>
                                                    <div class="text">
                                                        <div class="clearfix">
                                                            <div class="user">
                                                                Michael P
                                                            </div>
                                                            <div class="message-date">November 13, 2015 at 4:52:01 PM GMT+1</div>
                                                        </div>
                                                        Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?
                                                    </div>
                                                </div>
                                                <div class="item clearfix">
                                                    <div class="avatar">
                                                        <img src="<?= Url::to('@web/imgs/profile.jpg') ?>" alt="">
                                                    </div>
                                                    <div class="text">
                                                        <div class="clearfix">
                                                            <div class="user">
                                                                Daniel J <span class="label label-primary">Support</span>
                                                            </div>
                                                            <div class="message-date">November 13, 2015 at 4:51:51 PM GMT+1</div>
                                                        </div>
                                                        <p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
                                                        <p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?</p>
                                                    </div>
                                                </div>
                                                <div class="item clearfix">
                                                    <div class="avatar">
                                                        <img src="<?= Url::to('@web/imgs/profile.jpg') ?>" alt="">
                                                    </div>
                                                    <div class="text">
                                                        <div class="clearfix">
                                                            <div class="user">
                                                                Daniel J <span class="label label-primary">Support</span>
                                                            </div>
                                                            <div class="message-date">November 13, 2015 at 4:51:51 PM GMT+1</div>
                                                        </div>
                                                        <p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
                                                        <p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?</p>
                                                    </div>
                                                </div>
                                                <div class="item alternative clearfix">
                                                    <div class="avatar">
                                                        <img src="<?= Url::to('@web/imgs/profile.jpg') ?>" alt="">
                                                    </div>
                                                    <div class="text">
                                                        <div class="clearfix">
                                                            <div class="user">
                                                                Michael P
                                                            </div>
                                                            <div class="message-date">November 13, 2015 at 4:52:01 PM GMT+1</div>
                                                        </div>
                                                        Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if ( count( $categories ) >= 1 ) { ?>
        <div class="row mt20">
            <div class="col-sm-12">
                <h4>FAQs</h4>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <?php foreach ( $categories as $cat_idx => $category ) : /** @var FaqCategory $category */ ?>
                    <div class="col-head faq-col-head">
                        <h5><?= $category->name ?></h5>
                    </div>
                    <div class="faq">
                        <div class="panel">
                            <div class="panel-group" id="faq_accordion" role="tablist">
                                <ul>
                                    <?php foreach ( $category->faqQuestions as $q_idx => $question ) { ?>
                                        <li>
                                            <div class="panel-heading" role="tab" id="faq_heading_<?= $cat_idx ?>">
                                                <h4 class="panel-title">
                                                    <?= Html::a( $question->title, '#faq_' . $cat_idx . $q_idx, [ 'class' => 'pageLink collapsed', 'role' => 'button', 'data-toggle' => 'collapse', 'data-parent' => '#faq_accordion', 'data-no-scroll' => 'true' ] ) ?>
                                                </h4>
                                            </div>
                                            <div id="<?= 'faq_' . $cat_idx . $q_idx ?>" class="panel-collapse collapse" role="tabpanel">
                                                <div class="panel-body">
                                                    <?= $question->description ?>
                                                </div>
                                            </div>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
        <?php } ?>

        <?= $this->render('/layouts/_footer') ?>

    </div>
<?php
$this->js['faqs'][] = <<<EOS
EOS;
?>
<?= \backend\components\helpers\JsTools::viewJs($this) ?>
