<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <?php if ($formModel->scenario == 'update') { ?>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
    <?php } else { ?>
    <div class='modal-tabs'>
        <div class='modal-tab active'>Spent Money</div>
        <div class='modal-tab open-modal' data-modal-url='/incomes/add-onetime-income'>Received Money</div>
        <div class='modal-tab open-modal' data-modal-url='/transfers/add-onetime-transfer'>Transfered Money</div>
    </div>
    <?php } ?>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-transaction-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'formattedDate')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('When did you spend the money?') ?>

    <?= $form->field($formModel, 'description')->label('Description') ?>

    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ])->label('How much did you spend?') ?>

    <?= $form->field($formModel, 'jar_id')->dropDownList($jars, [
        'prompt' => 'Select one',
        'options' => $jarsOptions
    ])->label('Jar'); ?>

    <?= $form->field($formModel, 'expense_id', [
        'hintOptions' => ['style' => 'display:none']
        ])->dropDownList($expenses, [
            'prompt' => 'Other (unbudgeted)',
            'options' => $expensesOptions
        ])
        ->label("Expense (leave 'other' for an unbudgeted expense)")
        ->hint('This is a recurring expense. The transactions are automatically generated by the system.'); ?>

    <?= $form->field($formModel, 'debt_id', [
        'options' => [
            'class' => 'form-group',
            'style' => 'display:none'
        ]
        ])->dropDownList($debts, [
            'prompt' => 'Select one',
        ])
        ->label("Debt"); ?>

    <?= $form->field($formModel, 'account_id')->dropDownList($accounts, [
        'prompt' => 'Select one',
        'options' =>
            [
                $selectedAccount => ['selected' => true]
            ]
    ])->label('Account'); ?>

    <?= $form->field($formModel, 'tax_deductible')
        ->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])
        //->hint('If this Transaction is tax deductible check this box and Grandma’s Jars will include the Transaction in the ‘Tax deductible expenses report’');
    ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton(
        $formModel->scenario == 'update' ? 'Save Transaction' : 'Add Transaction',
        [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => $jsCallback ? $jsCallback : 'reloadMoneyOperationsTable',
            'data-submit-url' => $formModel->scenario == 'update' ?
                Url::toRoute(['/transactions/edit-es-transaction', 'id' => $id]) :
                Url::toRoute(['/transactions/add-es-transaction'])
        ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
