<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-transaction-form']); ?>
<div class="modal-body">
    <div class="message"></div>
    <?= $form->field($formModel, 'description', [
        'inputOptions' => [
            'value' => $formModel->description
        ]
    ])->label('Description') ?>
    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ])->label('Amount') ?>
    <?=
    $form->field($formModel, 'formattedDate')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('Transaction date')
    ?>
    <?=
    $form->field($formModel, 'account_id')->dropDownList($accounts, [
        'prompt' => 'Select one',
        'options' =>
            [
                $selectedAccount => ['selected' => true]
            ]
    ])->label('Default Account');
    ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Transaction', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => 'reloadExpenseJarEstimatedExpenses', 'data-submit-url' => Url::toRoute(['/transactions/add-transaction', 'expense_id' => $expenseId])]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
