<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
use backend\components\helpers\Formatter;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'edit-transfer-form']); ?>
<div class="modal-body">

    <div class="message"></div>

    <?= $form->field($formModel, 'name')->label('Description') ?>


    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ]) ?>

    <?=
    $form->field($formModel, 'frequency')->dropDownList($frequencies, [
        'prompt' => 'Select one'
    ]);
    ?>

    <?=
    $form->field($formModel, 'formattedDate')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('Next Transfer Date')
    ?>

    <?=
    $form->field($formModel, 'account_from_id')->dropDownList($accounts, [
        'prompt' => 'Select one'
    ])->label('From Account');
    ?>

    <?=
    $form->field($formModel, 'account_to_id')->dropDownList($accounts, [
        'prompt' => 'Select one'
    ])->label('To Account');
    ?>

</div>
<div class="modal-footer">

    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Save Transfer', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadTransfersAfterEdit'), 'data-submit-url' => Url::toRoute(['/transfers/edit-transfer', 'id' => $transferId])]) ?>

</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


