<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'remove-transfer-form']); ?>
<div class="modal-body">
    <p>Do you really wish to remove this transfer?</p>
    <?php if ($hardDeletable) { ?>
    <ul>
        <li><strong>Delete Transfer</strong> when the transfer is no longer valid (keeps past transfer data)</li>
        <li><strong>Delete Transfer and all Associated Transactions</strong> when the transfer was added in a mistake (deletes all past and current data)</li>
    </ul>
    <?php } else { ?>
    <p>This <strong>will keep</strong> past transfer data.</p>
    <?php } ?>

    <?php if (isset($frequency) && ($frequency == 'one-time') && $hardDeletable) { ?>
    <p class="note">Removing this transfer will remove all associated transfer events.</p>
    <?php } ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Delete Transfer', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => 'reloadTransfersAfterRemove', 'data-submit-url' => Url::toRoute(['/transfers/remove-transfer', 'id' => $transferId, 'confirm' => 1])]) ?>
    <?php if ($hardDeletable) { ?>
    <?= Html::submitButton('Delete Transfer and all Associated Transactions', ['class' => 'btn btn-danger ajax-submit', 'data-js-callback' => 'reloadTransfersAfterRemove', 'data-submit-url' => Url::toRoute(['/transfers/remove-transfer', 'id' => $transferId, 'confirm' => 1, 'hard' => 1])]) ?>
    <?php } ?>
</div>
<?php ActiveForm::end(); ?>
