<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\widgets\FormattedTitle;
use backend\components\helpers\JsTools;
?>
<div id="body" class="container-fluid user-report-container" data-js-callback="usersLoaded" data-select-menu="li.view-my-profile" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-lg-12">
            <div class="col-head">
                <h3>User Profile</h3>
            </div>
            <div class="cr-print">
                <a href="javascript:window.print()" target="_blank" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print Report</a>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <h4>Basic information</h4>
            <div class="label-group">
                <label>Username</label>
                <span class="label-value"><?= $user->username ?></span>
            </div>
            <div class="label-group">
                <label>Email Address</label>
                <span class="label-value"><?= $user->email; ?></span>
            </div>
            <?php if (strlen($user->getFullName())) { ?>
            <div class="label-group">
                <label>Full Name</label>
                <span class="label-value"><?= $user->getFullName() ?></span>
            </div>
            <?php } ?>
            <?php if (isset($meta['birth_date']) && (strlen($meta['birth_date']) > 0)) { ?>
            <div class="label-group">
                <label>Date of Birth</label>
                <span class="label-value"><?= Formatter::date(strtotime($meta['birth_date'])) ?></span>
            </div>
            <?php } ?>
            <?php if (isset($meta['email_notifications'])) { ?>
            <div class="label-group">
                <label>Email Notifications</label>
                <span class="label-value"><?= $meta['email_notifications'] ? 'Yes' : 'No'; ?></span>
            </div>
            <?php } ?>
        </div>
        <div class="col-sm-6">
            <h4>Address & extra information</h4>
            <?php if (isset($meta['address_one_line']) && (strlen($meta['address_one_line']) > 0)) { ?>
            <div class="label-group">
                <label>Address</label>
                <span class="label-value"><?= $meta['address_one_line'] ?></span>
            </div>
            <?php } ?>
            <?php if (isset($meta['landline_number']) && (strlen($meta['landline_number']) > 0)) { ?>
            <div class="label-group">
                <label>Phone Number</label>
                <span class="label-value"><?= $meta['landline_number'] ?></span>
            </div>
            <?php } ?>
            <?php if (isset($meta['cellphone_number']) && (strlen($meta['cellphone_number']) > 0)) { ?>
            <div class="label-group">
                <label>Mobile Phone Number</label>
                <span class="label-value"><?= $meta['cellphone_number'] ?></span>
            </div>
            <?php } ?>
            <?php if (isset($meta['skype_name']) && (strlen($meta['skype_name']) > 0)) { ?>
            <div class="label-group">
                <label>Skype Account</label>
                <span class="label-value"><?= $meta['skype_name'] ?></span>
            </div>
            <?php } ?>
            <?php if (isset($meta['country_name']) && (strlen($meta['country_name']) > 0)) { ?>
            <div class="label-group">
                <label>Country</label>
                <span class="label-value"><?= $meta['country_name'] ?></span>
            </div>
            <?php } ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <h4>Subscription</h4>

            <div class="label-group">
                <label>Active User Plan Type</label>
                <span class="label-value"><?= $userPlan->userPlanType->name; ?></span>
            </div>

            <div class="label-group">
                <label>User Plan Activated or Extended</label>
                <span class="label-value"><?= Formatter::datetime($userPlan->start_time); ?></span>
            </div>

            <div class="label-group">
                <label>Registered Since</label>
                <span class="label-value"><?= Formatter::datetime($registration->auth_time); ?></span>
            </div>
        </div>

        <div class="col-sm-6">
            <h4>Activity</h4>

            <div class="label-group">
                <label>Log-ins Count This Month</label>
                <span class="label-value"><?= $loginCount; ?></span>
            </div>

            <div class="label-group">
                <label>Total Time Logged In</label>
                <span class="label-value"><?= $loginDuration; ?></span>
            </div>
        </div>

    </div>

    <div class="row">
        <div class="col-sm-12">
            <h4>Expense Changes This Month</h4>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Name</th>
                        <th>Parameter</th>
                        <th>From</th>
                        <th>To</th>
                    </tr>
                </thead>
                <?php if (count($expenseChanges)) { ?>
                <?php foreach ($expenseChanges as $e) { ?>
                <tr>
                    <td><?= Formatter::datetime($e['time']) ?></td>
                    <td><?= $e['name'] ?></td>
                    <td><?= $e['parameter'] ?></td>
                    <td><?= $e['from'] ?></td>
                    <td><?= $e['to'] ?></td>
                </tr>
                <?php } ?>
                <?php } else { ?>
                <tr>
                    <td colspan="5">No changes this month.</td>
                </tr>
                <?php } ?>
            </table>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <h4>Overspending Jars</h4>

            <?php if (count($overspendingJars)) { ?>
            <?php foreach ($overspendingJars as $o) { ?>
            <p><?= $o['name'] ?> ... <?= Formatter::currency($o['balance']) ?></p>
            <?php } ?>
            <?php } else { ?>
            <p>No overspending jars.</p>
            <?php } ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <h4>Notes</h4>

            <?php if (count($notes)) { ?>
            <?php foreach ($notes as $n) { ?>
            <?php if (strlen(strip_tags($n->content))) { ?>
            <div class="cr-note">
                <h5><?= $n->name ?></h5>
                <div class="content"><?= $n->content ?></div>
                <p class="last-edited">(Last edited on <?= Formatter::datetime($n->time_edited) ?>)</p>
            </div>
            <?php } ?>
            <?php } ?>
            <?php } else { ?>
            <p>No notes yet.</p>
            <?php } ?>
        </div>
    </div>

</div>
