<?php
namespace backend\widgets;

use backend\models\db\Budget;
use backend\models\db\Expense;
use backend\models\db\Jar;
use yii\base\Exception;
use yii\base\Widget;

class BudgetShortfallCalculator extends Widget
{
    public $budgetId;
    public $jarId;
    public $containerClass;
    public $callbackUrl;
    public $amounts = [];


    public function init()
    {
        parent::init();
        if (!$this->budgetId) {
            throw new Exception('Budget ID must be provided');
        }
        if (!$this->callbackUrl) {
            throw new Exception('Callback URL must be provided');
        }
    }

    public function run()
    {
        if ($this->jarId) {
            $jar = Jar::findOne($this->jarId);
        }

        // get jars
        $budget = Budget::findOne($this->budgetId);
        $jars   = $budget->getActiveJars();
        $jarIds = [];

        $allJars = [
            [
                'id' => 0,
                'label' => '[All jars]',
                'url' => '#',
                'options' => [
                    'class' => 'skip-history'
                ],
                'linkOptions' => [
                    'class' => 'system-link',
                    'data-jar-id' => 0
                ]
            ]
        ];
        foreach ($jars as $j) {
            $jarIds[] = $j->id;
            $allJars[] = [
                'id' => $j->id,
                'label' => strval($j->name),
                'url' => '#',
                'options' => [
                    'class' => 'skip-history'
                ],
                'linkOptions' => [
                    'class' => 'system-link',
                    'data-jar-id' => $j->id
                ]
            ];
        }

        $expenses = Expense::find()
            ->where([
                'or',
                [
                    'and',
                    ['frequency' => 'one-time'],
                    ['>', 'date', date('Y-m-d')],
                    ['!=', "CONCAT(YEAR(date), '-', MONTH(date))", date('Y-n')]
                ],
                [
                    'and',
                    ['frequency' => ['quarterly', 'semi-annually', 'annually']]
                ]
            ])
            ->andWhere([
                'jar_id' => $this->jarId ? $this->jarId : $jarIds,
                'is_unbudgeted' => 0,
                'is_adjustment' => 0,
                'archived' => 0
            ])
            ->orderBy('name ASC')
            ->all();

        return $this->render('budget-shortfall-calculator', [
            'budgetId' => $this->budgetId,
            'jarId' => $this->jarId,
            'allJars' => $allJars,
            'jarName' => $this->jarId ? $jar->name : '[All jars]',
            'expenses' => $expenses,
            'containerClass' => $this->containerClass,
            'callbackUrl' => $this->callbackUrl,
            'amounts' => $this->amounts
        ]);
    }
}