<?php

namespace backend\widgets;

use yii\base\Widget;
use backend\widgets\Tooltip;


class JarTooltip extends Widget {

	private static $JAR_TOOLTIPS = [
		'everyday' => 'The Everyday Jar could include the following expenses - Groceries, Dining out, Pocket Money, Coffee and drinks to go, Everyday Entertainment, Cigarettes, Gas/Petrol, and Public Transportation Tickets.',
		'utilities' => 'The Utilities Jar could include the following expenses - Gas for heating, electricity, rent, water, building maintenance, and garbage collection.',
		'communication' => 'The Communications Jar could inclue the following expenses - Mobile phone plan payments and telephone landline payments.',
		'grooming' => 'The Grooming Jar could include the following expenses - Clothes, Haircuts, Cosmetics, Shoes, Dry Cleaning, and Beauty Treatments.',
		'health' => 'The Health Jar could include the following expenses - Health Insurance, Dentist, Doctor, Phyiscal Therapy, Counselling, Medication, and Vitamin Supplements.',
		'giving' => 'The Giving Jar could include the following expenses - Tithing, Missionary Suppport, Sponsored Children, and Donations.',
		'gifts' => 'The Gifts Jar could include the following expenses - Christmas Presents, Birthday Presents, Wedding Gifts, Name Day Gifts, and other Presents.',
		'kids' => 'The Kids Jar could include the following expenses - School Fees, School Trips, After School Activities, Music Lessons, Sports Activities, Child Care, Babysitting, and Kids Parties.',
		'entertainment' => 'The Entertainment Jar could include the following expenses - Movie Tickets, Concert Tickets, Season Tickets, and Special Events.',
		'car' => 'The Car Jar could include the following expenses – Registration, Maintenance, Insurance, Roadside Assistance, Licence renewals, Car leasing costs, Tyres etc. You may also want to include Caravan, trailer, boat and motorbike costs.',
		'sports' => 'The Sports and Hobbies Jar could include the following expenses - Gym Membership, Club Fees, Hobby Equipment, Sports Equipment, Magazine Subscriptions, and Events and Conventions.',
		'household' => 'The Household Jar could include the following expenses - Gardening, Furniture Replacement, Stove/Fridge Replacement, Home Improvements, and Ironing/Cleaning.',
		'proFees' => 'The Professional Fees Jar could include the following expenses - Accountant/Tax Return, Financial Adviser, Professional Indemnity, and Term Life Insurance.',
		'proDevelopment' => 'The Professional Development Jar could include the following expenses - Books/Stationary, Course Fees, Conferences, Study Fees, and Association Fees.',
		'insurance' => 'The Insurances Jar could include the following expenses - Special Insurance, Homeowner’s Insurance, and Non-Car or Life Insurance.',
		'pets' => 'The Pets Jar could include the following expenses - Vet Fees and Vaccinations, Pet Food, Holiday Accomodation, and Pet Toys/Equipment.',
		'holidays' => 'The Holidays Jar could include the following expenses - Getaway Weekends, International and Domestic Travel, Passport Renewals, Visas, and Vaccinations for Travel.',
		'investments' => 'The Investments Jar could include the following expenses - Trading Fees, Annual Brokerage Fees, and Upkeep Costs.'
	];

	public $type = 'custom';
	public $position = 'bottom';

    public function run() {
    	$text = self::$JAR_TOOLTIPS[$this->type];
    	if ($text) {
    		return Tooltip::widget(['text' => $text, 'position' => $this->position]);
    	}
    	return '';
   	}
 }
