<?php

namespace backend\widgets;

use yii\base\Widget;
use yii\helpers\Html;

class Tooltip extends Widget {

    public $text;
    public $position = 'auto';
    public $class = '';

    public function run() {

        $classHtml = strlen($this->class) > 0 ? ' ' . $this->class : '';

        $out = '<a href="#" class="custom-tooltip' . $classHtml. '"
            data-toggle="tooltip"
            data-container="body"
            data-placement="' . $this->position . '"
            title="' . $this->text . '" onclick="return false"><i class="glyphicon glyphicon-info-sign"></i></a>';

        return $out;
    }

}
