<?php

namespace backend\widgets;

use backend\components\helpers\Formatter;
use yii\base\Widget;

use backend\models\db\Notification;

use yii\helpers\Url;

class UnreadNotifications extends Widget {

    public $userId;

    public function run() {

        $out = '';

        $notifications = Notification::find()
            ->where([
                'read' => 0,
                'archived' => 0,
                'user_id' => $this->userId
            ])
            ->orderBy('id DESC')
            ->all();

        foreach ($notifications as $n) {

            $out .=
                '<li id="alert-notification" class="alert-ntf-item clear" data-notification-id="' . $n->id . '">' .
                    '<div id="alert-notification-' . $n->id . '-canvas" class="option-canvas clear">' .
                        '<div id="alert-notification-' . $n->id . '-options" class="alert-options navmenu-fixed-left offcanvas">' .
                            '<a class="btn btn-primary mark-as-read" href="' . Url::toRoute(['/notifications/mark-as-read', 'notification_id' => $n->id]) . '">Mark as Read</a>' .
                            '<a class="btn btn-danger system-link" href="' . Url::toRoute(['/notifications']) . '">View</a>' .
                            '<button id="alert-notification-' . $n->id . '-options-close" class="menu-btn pull-right" data-toggle="offcanvas" data-canvas="#alert-notification-' . $n->id . '-canvas" data-target="#alert-notification-' . $n->id . '-options" type="button">' .
                                '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>' .
                            '</button>' .
                        '</div>' .
                        '<div class="alert-ntf-left">' .
                            '<div class="alert-ntf-right">' .
                                '<div class="notification-icon notification-category-' . $n->notificationTemplate->notification_category_id . '">' .
                                    '<i class="glyphicon ' . $n->notificationTemplate->getTemplateGlyphicon() . '"></i>' .
                                '</div>' .
                                '<p>' .
                                    $n->content .
                                    '<span class="date">' . Formatter::datetime(strtotime($n->created_at)) . '</span>' .
                                '</p>' .
                            '</div>' .
                            '<button id="alert-notification-' . $n->id . '-options-open" class="menu-btn btn-options-open pull-right" data-toggle="offcanvas" data-canvas="#alert-notification-' . $n->id . '-canvas" data-target="#alert-notification-' . $n->id . '-options" type="button">' .
                                '<span class="glyphicon glyphicon-cog" aria-hidden="true"></span>' .
                            '</button>' .
                        '</div>' .
                    '</div>' .
                '</li>';

        }

        return $out;

    }

}
