<?php

namespace backend\widgets;

use Yii;
use yii\base\Widget;
use yii\helpers\Url;

class VideoTutorial extends Widget
{
    public $id = null;
    public $type = null;
    public $hideable = true;
    public $onlyVideo = false;

    public function run() {
        $config = Yii::$app->params['videoTutorialConfig'];
        $props = $config['default'];
        if (isset($config[$this->type])) {
            $props = $config[$this->type];
        }
        if ($this->id) {
            $props['id'] = $this->id;
        }
        if ($this->onlyVideo) {
            $props['onlyVideo'] = $this->onlyVideo;
        }
        $props['hideable'] = $this->hideable;
        $props['thumbUrl'] = "https://img.youtube.com/vi/{$props['id']}/maxresdefault.jpg";
        if (!@file_get_contents($props['thumbUrl'])) {
            $props['thumbUrl'] = "https://img.youtube.com/vi/{$props['id']}/hqdefault.jpg";
        }
        return $this->render('video-tutorial', $props);
    }
}
