<?php
use backend\components\helpers\Formatter;
use backend\models\db\Expense;
use yii\bootstrap\ButtonDropdown;
use backend\widgets\Tooltip;

$total = 0;
$totalShortfall = 0;
$totalAdjusted  = 0;
?>
<div class="row budget-shortfall-calculator <?= $containerClass ?>">
    <div class="col-md-12">
        <div class="col-head">
            <h3>Budget Shortfall Calculator</h3>
            <?= ButtonDropdown::widget([
                'label' => $jarName,
                'dropdown' => [
                    'items' => $allJars,
                ]
            ]); ?>
        </div>
        <div class="panel panel-table panel-user-dashboard">
            <table class="table table-bordered">
                <thead class="color-0">
                <tr>
                    <th class="align-center">Expense Description</th>
                    <th class="align-center">
                        Frequency
                        <?= Tooltip::widget(['text' => 'This is how often this expense / bill occurs.']) ?>
                    </th>
                    <th class="align-center">
                        Amount Next Due
                        <?= Tooltip::widget(['text' => 'The amount next due is how much you anticipate the next bill for this expense to be.']) ?>
                    </th>
                    <th class="align-center">
                        Monthly Amount
                        <?= Tooltip::widget(['text' => 'This is the default monthly allocation to this expense of 1/12th of the annual expense total.']) ?>
                    </th>
                    <th class="align-center">
                        Due Date
                        <?= Tooltip::widget(['text' => 'The Due date is when the next known bill for this expense is due.']) ?>
                    </th>
                    <th class="align-center">
                        Will Have Saved<br/>by Due Date
                        <?= Tooltip::widget(['text' => 'This is the amount you will have saved by the due date by setting aside 1/12th of the annual expense each month.']) ?>
                    </th>
                    <th class="align-center">
                        Shortfall Amount
                        <?= Tooltip::widget(['text' => 'The Shortfall amount identifies how much you will fall short of covering this expense by it\'s next due date if you start putting aside 1/12th today.']) ?>
                    </th>
                    <th class="align-center">
                        Adjusted Monthly
                        <?= Tooltip::widget(['text' => 'This is how much you ideally need to allocate to this expense each month between now and it\'s next due date to avoid having a shortfall.']) ?>
                    </th>
                    <th class="align-center">
                        Top Up From Savings
                        <?= Tooltip::widget(['text' => 'This field helps you see how much you would need to allocate to each expense from savings to negate any shortfall that may occur from allocating 1/12th of the annual expense each month.']) ?>
                    </th>
                </tr>
                </thead>
                <tbody>
                <?php if (count($expenses)) {
                    /** @var Expense $e */
                    foreach ($expenses as $e) {
                        $adjusted  = $e->getAdjustedMonthlyAmount(isset($amounts[$e->id]) ? $amounts[$e->id] : null);
                        $shortfall = $e->getShortfallAmount(isset($amounts[$e->id]) ? $amounts[$e->id] : null);
                        $total += $e->getAverageMonthlyAmount();
                        $totalAdjusted  += $adjusted;
                        $totalShortfall += $shortfall;
                ?>
                <tr class="expense-row" data-jar-id="<?= $e->jar_id ?>" data-id="<?= $e->id ?>">
                    <td><?= $e->name ?></td>
                    <td><?= $e->frequency ?></td>
                    <td class="align-right"><?= Formatter::currency($e->amount) ?></td>
                    <td class="align-right"><?= Formatter::currency($e->getAverageMonthlyAmount()) ?></td>
                    <td class="align-center"><?= Formatter::date($e->getNextDue($e->expenseStart->date)) ?></td>
                    <td class="align-right"><?= Formatter::currency($e->getSavedByDueDate(true)) ?></td>
                    <td class="align-right<?= $shortfall < 0 ? ' gj-is-negative' : '' ?>">
                        <?= Formatter::currency($shortfall) ?>
                    </td>
                    <td class="align-right"><?= Formatter::currency($adjusted) ?></td>
                    <td class="align-center">
                        <input type="text" class="amount-saved align-right" value="<?=
                            Formatter::currency(isset($amounts[$e->id]) ? $amounts[$e->id] : ($e->getAmountAlreadySaved() ? $e->getAmountAlreadySaved() : 0), 'none')
                        ?>" />
                    </td>
                </tr>
                <?php }
                } else { ?>
                <tr>
                    <td colspan="9">No expenses yet!</td>
                </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="well budget-shortfall-totals">
            <div class="row">
                <div class="col-md-3">
                    <strong>Totals</strong>
                </div>
                <div class="col-md-3">
                    Monthly: <?= Formatter::currency($total) ?>
                </div>
                <div class="col-md-3">
                    Adjusted monthly: <?= Formatter::currency($totalAdjusted) ?>
                </div>
                <div class="col-md-3 gj-is-negative">
                    Shortfall: <?= Formatter::currency($totalShortfall) ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        var calc = '.budget-shortfall-calculator ';
        $('body').on('click', calc + '.dropdown-menu li a', function() {
            $(calc).blockloader();
            var jarId = $(this).data('jar-id');
            $.ajax({
                url: '<?= $callbackUrl ?>',
                method: 'post',
                data: {
                    budgetId: <?= $budgetId ?>,
                    jarId: jarId
                },
                complete: function(result, status) {
                    if (status == 'success') {
                        $(calc + '.btn-group').html($(result.responseText).find('.btn-group').html());
                        $(calc + '.btn-group').removeClass('open');
                        $(calc + 'table tbody').html('');
                        $(calc + 'table tbody').html($(result.responseText).find('table tbody').html());
                        $('.budget-shortfall-totals').html($(result.responseText).find('.budget-shortfall-totals').html());
                    }
                    $(calc).blockloader('hide');
                }
            });
            return false;
        });
        $('body').on('change', '.amount-saved', function() {
            $(calc).blockloader();
            var amounts = [];
            $(calc + '.amount-saved').each(function() {
                amounts.push(
                    'amounts[' + $(this).parents('tr').data('id') + ']' +
                    '=' +
                    $(this).val()
                );
            });

            $.ajax({
                url: '<?= $callbackUrl ?>',
                method: 'post',
                data: 'budgetId=<?= $budgetId ?>&' +
                    'jarId=<?= $jarId ?>&' +
                    amounts.join('&'),
                complete: function(result, status) {
                    if (status == 'success') {
                        $(result.responseText).find('tr.expense-row').each(function() {
                            var dataId = $(this).data('id');
                            $(calc + 'tr.expense-row[data-id=' + dataId + ']').html($(this).html());
                        });
                        $('.budget-shortfall-totals').html($(result.responseText).find('.budget-shortfall-totals').html());
                    }
                    $(calc).blockloader('hide');
                }
            });
        });
    });
</script>