<?php

namespace common\models\form;

use yii\base\Model;

/**
 * Login form
 */
class ForgottenPassword extends Model
{
    public $username;
    public $email;

    protected $whenBackendUsername;
    protected $whenFrontendUsername;
    protected $whenBackendEmail;
    protected $whenFrontendEmail;

    public function init()
    {
        $this->whenBackendUsername = function($model) {
            return empty($model->email);
        };
        $this->whenFrontendUsername = "function() {
            return $('#forgottenpassword-email').val().length <= 0;
        }";
        $this->whenBackendEmail = function($model) {
            return empty($model->username);
        };
        $this->whenFrontendEmail = "function() {
            return $('#forgottenpassword-username').val().length <= 0;
        }";
    }
    
    public function rules()
    {
        // validate input
        $validationRules = [
            ['username', 'required', 'when' => $this->whenBackendUsername, 'whenClient' => $this->whenFrontendUsername],
            ['email', 'required', 'when' => $this->whenBackendEmail, 'whenClient' => $this->whenFrontendEmail],
            ['username', 'exist', 'targetClass' => new \backend\models\db\User(), 'when' => $this->whenBackendUsername, 'whenClient' => $this->whenFrontendUsername],
            ['email', 'exist', 'targetClass' => new \backend\models\db\User(), 'when' => $this->whenBackendEmail, 'whenClient' => $this->whenFrontendEmail]
        ];
        
        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];
                
        return array_merge($validationRules, $filterRules);
    }
}