<?php

namespace common\models\form;

use yii\base\Model;

/**
 * Login form
 */
class Login extends Model {

    public $username;
    public $password;
    public $rememberMe = true;

    public function rules() {
        
        // validate input
        $validationRules = [
            ['username', 'required'],
            ['password', 'required'],
            ['rememberMe', 'boolean'],
        ];
        
        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];
                
        return array_merge($validationRules, $filterRules);
        
    }

}
