<?php

namespace common\models\form;

use yii\base\Model;

/**
 * Login form
 */
class RegisterResend extends Model {

    public $username;
    
    public function rules() {
        
        // validate input
        $validationRules = [
            ['username', 'required'],
            ['username', 'exist', 'targetClass' => new \backend\models\db\User()]
        ];
        
        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];
                
        return array_merge($validationRules, $filterRules);
        
    }
    
}