<?php

namespace common\models\form;

use backend\models\db\User;
use backend\models\db\UserPlan;
use backend\models\db\UserPlanType;
use backend\models\db\UserRole;
use yii\base\Model;

/**
 * Reset Password form
 */
class ResetPassword extends Model
{
    public $email;
    public $username;
    public $password;
    public $passwordConfirm;

    
    public function rules()
    {
        // validate input
        $validationRules = [
            ['username', 'required', 'on' => ['setup', 'setup-not-unique']],
            ['username', 'string', 'min' => 8, 'on' => ['setup', 'setup-not-unique']],
            ['username', 'match', 'not' => true, 'pattern' => '/ /', 'message' => 'Username may not contain spaces.', 'on' => ['setup', 'setup-not-unique']],
            ['username', 'validateBootcampUser', 'on' => ['setup', 'setup-not-unique']],
            ['email', 'required', 'on' => 'setup-not-unique'],
            ['email', 'email', 'on' => 'setup-not-unique'],
            ['email', 'unique', 'targetClass' => 'backend\models\db\User', 'targetAttribute' => 'email', 'on' => 'setup-not-unique'],
            [['password', 'passwordConfirm'], 'required'],
            ['passwordConfirm', 'compare', 'compareAttribute' => 'password']
        ];
        
        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];
                
        return array_merge($validationRules, $filterRules);
    }

    public function validateBootcampUser($attribute)
    {
        // throw an error only when the user exists and is NOT on Bootcamp plan
        $bootcampUser = $this->checkBootcampUser($attribute);
        if ($bootcampUser === false) {
            $this->addError($attribute, "This {$attribute} has already been taken.");
        }
    }

    protected function checkBootcampUser($attribute = 'username')
    {
        $bootcamp = UserPlanType::getPlanTypeObject(UserPlanType::PLAN_TYPE_BOOTCAMP);
        $bootcampAccess = UserPlanType::getPlanTypeObject(UserPlanType::PLAN_TYPE_BOOTCAMP_ACCESS);

        $user = User::find()
            ->where([
                $attribute => $this->$attribute,
                'user_role_id' => UserRole::CLIENT
            ])
            ->one();
        if ($user) {
            $userPlan = UserPlan::getActivePlan($user->id);
            if (!$userPlan ||
                ($userPlan && $userPlan->user_plan_type_id != $bootcamp->id && $userPlan->user_plan_type_id != $bootcampAccess->id)) {
                return false;
            }
            return $user;
        }
        return null;
    }
}