<?php
namespace console\controllers;

use backend\components\MandrillHelper;

class MandrillController extends \yii\console\Controller
{
    public function actionImport1()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/registration-confirm', [
            'username' => '{{username}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/registration-confirm', [
            'username' => '{{username}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'registration-confirm',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Registration Confirmation',
            $html,
            $text,
            true
        );
    }

    public function actionImport2()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/registration', [
            'username' => '{{username}}',
            'auth_url' => '{{auth_url}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/registration', [
            'username' => '{{username}}',
            'auth_url' => '{{auth_url}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'registration',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Action Required: Activate Your Account',
            $html,
            $text,
            true
        );
    }

    public function actionImport3()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/receipt', [
            'username' => '{{username}}',
            'invoice_id' => '{{invoice_id}}',
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/receipt', [
            'username' => '{{username}}',
            'invoice_id' => '{{invoice_id}}',
        ], 'layouts/text');
        $mandrill->templates->add(
            'receipt',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Payment Confirmation',
            $html,
            $text,
            true
        );
    }

    public function actionImport4()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/invoice', [
            'username' => '{{username}}',
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/invoice', [
            'username' => '{{username}}',
        ], 'layouts/text');
        $mandrill->templates->add(
            'invoice',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'New Invoice from Grandma’s Jars',
            $html,
            $text,
            true
        );
    }

    public function actionImport5()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/notification', [
            'username' => '{{username}}',
            'notification' => '{{notification}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/notification', [
            'username' => '{{username}}',
            'notification' => '{{notification}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'notification',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'New notification!',
            $html,
            $text,
            true
        );
    }

    public function actionImport6()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/new-sub-client', [
            'username' => '{{username}}',
            'password' => '{{password}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/new-sub-client', [
            'username' => '{{username}}',
            'password' => '{{password}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'new-sub-client',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Confirmation: A user has been added to your account',
            $html,
            $text,
            true
        );
    }

    public function actionImport7a()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/forgotten-password-single', [
            'parent_username' => '{{parent_username}}',
            'login_url' => '{{login_url}}',
            'reset_url' => '{{reset_url}}',
            'username' => '{{username}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/forgotten-password-single', [
            'parent_username' => '{{parent_username}}',
            'login_url' => '{{login_url}}',
            'reset_url' => '{{reset_url}}',
            'username' => '{{username}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'forgotten-password-single',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Forgotten Password',
            $html,
            $text,
            true
        );
    }

    public function actionImport7b()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/forgotten-password-multi', [
            'parent_username' => '{{parent_username}}',
            'login_url' => '{{login_url}}',
            'request_count' => '{{request_count}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/forgotten-password-multi', [
            'parent_username' => '{{parent_username}}',
            'login_url' => '{{login_url}}',
            'request_count' => '{{request_count}}',
        ], 'layouts/text');
        $mandrill->templates->add(
            'forgotten-password-multi',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Forgotten Password',
            $html,
            $text,
            true
        );
    }

    public function actionImport8()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/coach-mock-budget-submitted', [
            'coach_username' => '{{coach_username}}',
            'username' => '{{username}}',
            'budget_url' => '{{budget_url}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/coach-mock-budget-submitted', [
            'coach_username' => '{{coach_username}}',
            'username' => '{{username}}',
            'budget_url' => '{{budget_url}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'coach-mock-budget-submitted',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'A mock budget has been created',
            $html,
            $text,
            true
        );
    }

    public function actionImport9()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/coach-eoms', [
            'coach_username' => '{{coach_username}}',
            'username' => '{{username}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/coach-eoms', [
            'coach_username' => '{{coach_username}}',
            'username' => '{{username}}',
            'login_url' => '{{login_url}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'coach-eoms',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Notification: An EOMS has been submitted',
            $html,
            $text,
            true
        );
    }

    public function actionImport10()
    {
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        $html = \Yii::$app->mailer->render('html/failed-crons', [
            'failed_crons_count' => '{{failed_crons_count}}',
            'failed_crons' => '{{failed_crons}}',
            'missing_crons_count' => '{{missing_crons_count}}',
            'missing_crons' => '{{missing_crons}}'
        ], 'layouts/html');
        $text = \Yii::$app->mailer->render('text/failed-crons', [
            'failed_crons' => '{{failed_crons}}',
            'missing_crons' => '{{missing_crons}}'
        ], 'layouts/text');
        $mandrill->templates->add(
            'failed-crons',
            \Yii::$app->params['supportEmail'],
            'Grandma’s Jars support',
            'Failed Crons Report',
            $html,
            $text,
            true
        );
    }

    public function actionTest()
    {
        $requests = [
            [
                'username' => 'test1',
                'reset_url' => 'http://reset_url_1'
            ],
            [
                'username' => 'test2',
                'reset_url' => 'http://reset_url_2'
            ],
            [
                'username' => 'test3',
                'reset_url' => 'http://reset_url_3'
            ]
        ];

        $res = MandrillHelper::sendEmail(
            'forgotten-password-multi',
            'Test email',
            [
                'username' => 'Test',
                'login_url' => 'http://login_url',
                'requestcount' => count($requests),
                'requests' => $requests
            ],
            'bartek@procreative.eu'
        );

        var_dump($res);
    }
}