<?php

namespace console\controllers;

use Yii;
use yii\console\Controller;
use backend\models\db\User;

class RbacController extends Controller {

    public function actionInit() {
        
        $auth = Yii::$app->authManager;
        
        // delete current rules
        $auth->removeAll();
                
        // existing roles
        $roles = [
            'subClient' => [
                'role' => $auth->createRole('sub-client')
            ],
            'client' => [
                'role' => $auth->createRole('client'),
                'children' => ['subClient']
            ],
            'coach' => [
                'role' => $auth->createRole('coach'),
                'children' => ['client']
            ],
            'superadmin' => [
                'role' => $auth->createRole('superadmin'),
                'children' => ['coach']
            ]
        ];
        
        // define permissions
        $permissions = [
            'subClient' => [
                'editJar' => [
                    'description' => 'Check if user can edit a jar.',
                    'rule' => new \console\rbac\EditJarRule()
                ],
                'accessBudget' => [
                    'description' => 'Check if user can access a budget.',
                    'rule' => new \console\rbac\AccessBudgetRule()
                ],
                'editEoms' => [
                    'description' => 'Check if user can edit an eoms.',
                    'rule' => new \console\rbac\EditEomsRule()
                ],
            ],
            'client' => [
                'addSubClient' => [
                    'description' => 'Add sub-clients to the main client account.',
                    'rule' => new \console\rbac\AddSubClient()
                ]
            ],
            'coach' => [
                
            ],
            'superadmin' => [
                
            ]
        ];
        
        // set up roles
        foreach ($roles as $role){
            $auth->add($role['role']);
        }
        
        // set up permissions
        foreach ($roles as $roleName => $role) {
            foreach ($permissions[$roleName] as $permissionName => $permission) {
                $p = $auth->createPermission($permissionName);
                $p->description = $permission['description'];
                                
                // check for a rule
                if (isset($permission['rule'])){
                    $auth->add($permission['rule']);
                    $p->ruleName = $permission['rule']->name;
                }
                
                $auth->add($p);
                
                if (isset($permission['parent'])){
                    $auth->addChild($p, $permission['parent']);
                }
                
                // assign to role
                $auth->addChild($role['role'], $p);
            }
            
            // assign children to this role
            if (isset($role['children'])){
                foreach ($role['children'] as $child){

                    $auth->addChild($role['role'], $roles[$child]['role']);

                }
            }
        }
        
        // give permissions to users
        $users = User::find()->all();
        
        foreach ($users as $user){
            
            $userRole = $user->getUserRole()->one()->name;
            $auth->assign($roles[$userRole]['role'], $user->id);
            
        }

        
    }

}
