<?php

use yii\db\Migration;
use yii\db\Schema;

class m160825_110910_jar_amounts_table extends Migration
{
    public function up()
    {
        $this->createTable('jar_amounts', [
            'id' => Schema::TYPE_PK,
            'jar_id' => Schema::TYPE_INTEGER . ' NOT NULL',
            'eoms_id' => Schema::TYPE_INTEGER . ' NULL DEFAULT NULL',
            'month' => Schema::TYPE_SMALLINT . '(2) NOT NULL',
            'year' => Schema::TYPE_SMALLINT . '(4) NOT NULL',
            'funds_brought_forward' => Schema::TYPE_DECIMAL . '(10,2) NOT NULL DEFAULT 0',
            'funds_remaining_adjustment' => Schema::TYPE_DECIMAL . '(10,2) NULL DEFAULT NULL'
        ]);
        $this->addForeignKey(
            'fk-jar_id',
            'jar_amounts',
            'jar_id',
            'jars',
            'id',
            'RESTRICT'
        );
        $this->addForeignKey(
            'fk-eoms_id',
            'jar_amounts',
            'eoms_id',
            'eoms',
            'id',
            'RESTRICT'
        );
    }

    public function down()
    {
        echo "m160825_110910_jar_amounts_table cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
