<?php

use yii\db\Migration;

class m160930_115100_add_currencies extends Migration
{
    public function up()
    {
        $this->addColumn('currencies', 'order', 'INTEGER NOT NULL DEFAULT 9999');
        $this->alterColumn('currencies', 'name', 'VARCHAR(50) NOT NULL');
        $this->alterColumn('currencies', 'sign', 'VARCHAR(10) NOT NULL');

        $this->update('currencies', ['order' => 0], ['code' => 'AUD']);
        $this->update('currencies', ['order' => 1], ['code' => 'USD']);
        $this->update('currencies', ['order' => 2], ['code' => 'EUR']);

        $this->insert('currencies', [
            'name' => 'British pound',
            'code' => 'GBP',
            'sign' => '£',
            'position' => 'B',
            'order' => 3
        ]);
        $this->insert('currencies', [
            'name' => 'Canadian dollar',
            'code' => 'CAD',
            'sign' => '$',
            'position' => 'B',
            'order' => 4
        ]);
        $this->insert('currencies', [
            'name' => 'New Zealand dollar',
            'code' => 'NZD',
            'sign' => '$',
            'position' => 'B',
            'order' => 5
        ]);

        $this->insert('currencies', [
            'name' => 'Argentine peso',
            'code' => 'ARS',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Armenian dram',
            'code' => 'AMD',
            'sign' => '֏',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Azerbaijani manat',
            'code' => 'AZN',
            'sign' => '₼',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Bahamian dollar',
            'code' => 'BSD',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Bahraini dinar',
            'code' => 'BHD',
            'sign' => '.د.ب',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Bolivian boliviano',
            'code' => 'BOB',
            'sign' => 'Bs.',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Brazilian real',
            'code' => 'BRL',
            'sign' => 'R$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Bulgarian lev',
            'code' => 'BGN',
            'sign' => 'лв',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Chilean peso',
            'code' => 'CLP',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Chinese yuan',
            'code' => 'CNY',
            'sign' => '元',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Croatian kuna',
            'code' => 'HRK',
            'sign' => 'kn',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Czech koruna',
            'code' => 'CZK',
            'sign' => 'Kč',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Danish krone',
            'code' => 'DKK',
            'sign' => 'kr',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Egyptian pound',
            'code' => 'EGP',
            'sign' => 'ج.م',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Hong Kong dollar',
            'code' => 'HKD',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Hungarian forint',
            'code' => 'HUF',
            'sign' => 'Ft',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Icelandic króna',
            'code' => 'ISK',
            'sign' => 'kr',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Indian rupee',
            'code' => 'INR',
            'sign' => '₹',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Indonesian rupiah',
            'code' => 'IDR',
            'sign' => 'Rp',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Iranian rial',
            'code' => 'IRR',
            'sign' => '﷼',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Iraqi dinar',
            'code' => 'IQD',
            'sign' => 'ع.د',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Israeli new shekel',
            'code' => 'ILS',
            'sign' => '₪',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Japanese yen',
            'code' => 'JPY',
            'sign' => '¥',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Jordanian dinar',
            'code' => 'JOD',
            'sign' => 'د.ا',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Kazakhstani tenge',
            'code' => 'KZT',
            'sign' => '₸',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Kenyan shilling',
            'code' => 'KES',
            'sign' => 'Sh',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'North Korean won',
            'code' => 'KPW',
            'sign' => '₩',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'South Korean won',
            'code' => 'KRW',
            'sign' => '₩',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Lebanese pound',
            'code' => 'LBP',
            'sign' => 'ل.ل',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Swiss franc',
            'code' => 'CHF',
            'sign' => 'Fr',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Malagasy ariary',
            'code' => 'MGA',
            'sign' => 'Ar',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Malaysian ringgit',
            'code' => 'MYR',
            'sign' => 'RM',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Maldivian rufiyaa',
            'code' => 'MVR',
            'sign' => '.ރ',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Mauritian rupee',
            'code' => 'MUR',
            'sign' => '₨',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Mexican peso',
            'code' => 'MXN',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Moldovan leu',
            'code' => 'MDL',
            'sign' => 'L',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Mongolian tögrög',
            'code' => 'MNT',
            'sign' => '₮',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Norwegian krone',
            'code' => 'NOK',
            'sign' => 'kr',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Peruvian nuevo sol',
            'code' => 'PEN',
            'sign' => 'S/',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Philippine peso',
            'code' => 'PHP',
            'sign' => '₱',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Polish złoty',
            'code' => 'PLN',
            'sign' => 'zł',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Romanian leu',
            'code' => 'RON',
            'sign' => 'lei',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'Russian ruble',
            'code' => 'RUB',
            'sign' => '₽',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Saudi riyal',
            'code' => 'SAR',
            'sign' => 'ر.س',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Serbian dinar',
            'code' => 'RSD',
            'sign' => 'дин.',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Singapore dollar',
            'code' => 'SGD',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'South African rand',
            'code' => 'ZAR',
            'sign' => 'R',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Swedish krona',
            'code' => 'SEK',
            'sign' => 'kr',
            'position' => 'A'
        ]);
        $this->insert('currencies', [
            'name' => 'New Taiwan dollar',
            'code' => 'TWD',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Thai baht',
            'code' => 'THB',
            'sign' => '฿',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Tunisian dinar',
            'code' => 'TND',
            'sign' => 'د.ت',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Turkish lira',
            'code' => 'TRY',
            'sign' => '₺',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Ukrainian hryvnia',
            'code' => 'UAH',
            'sign' => '₴',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'United Arab Emirates dirham',
            'code' => 'AED',
            'sign' => 'د.إ',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Uruguayan peso',
            'code' => 'UYU',
            'sign' => '$',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Vietnamese đồng',
            'code' => 'VND',
            'sign' => '₫',
            'position' => 'B'
        ]);
        $this->insert('currencies', [
            'name' => 'Yemeni rial',
            'code' => 'YER',
            'sign' => '﷼',
            'position' => 'B'
        ]);
    }

    public function down()
    {
        echo "m160930_115100_add_currencies cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
