<?php

use yii\db\Migration;

class m161010_094208_user_changes_tracking extends Migration
{
    public function up()
    {
        /* USERS table */
        $this->createTable('user_changes', [
            'id' => $this->primaryKey(),
            'user_record_id' => $this->integer()->notNull(),
            'time' => $this->timestamp()->notNull()->defaultExpression('CURRENT_TIMESTAMP'),
            'type' => $this->string(1)->notNull()->defaultValue('C'),
            'user_id' => $this->integer()->notNull(),
        ]);
        $this->addForeignKey('user_record_change_user_id',
            'user_changes', 'user_record_id',
            'users', 'id',
            'CASCADE', 'CASCADE'
        );
        $this->addForeignKey('user_change_user_id',
            'user_changes', 'user_id',
            'users', 'id',
            'CASCADE', 'CASCADE'
        );
        $this->createIndex('user_record_idx', 'user_changes', 'user_record_id');
        $this->createIndex('user_idx', 'user_changes', 'user_id');

        $this->createTable('user_change_meta', [
            'id' => $this->primaryKey(),
            'user_change_id' => $this->integer()->notNull(),
            'key' => $this->string(),
            'value' => $this->string()
        ]);
        $this->addForeignKey('user_change_meta_user_change_id',
            'user_change_meta', 'user_change_id',
            'user_changes', 'id',
            'CASCADE', 'CASCADE'
        );
        $this->createIndex('user_change_idx', 'user_change_meta', 'user_change_id');

        /* USER_META table */
        $this->createTable('user_meta_changes', [
            'id' => $this->primaryKey(),
            'user_meta_id' => $this->integer()->notNull(),
            'time' => $this->timestamp()->notNull()->defaultExpression('CURRENT_TIMESTAMP'),
            'type' => $this->string(1)->notNull()->defaultValue('C'),
            'user_id' => $this->integer()->notNull(),
        ]);
        $this->addForeignKey('user_meta_change_user_meta_id',
            'user_meta_changes', 'user_meta_id',
            'user_meta', 'id',
            'CASCADE', 'CASCADE'
        );
        $this->addForeignKey('user_meta_change_user_id',
            'user_meta_changes', 'user_id',
            'users', 'id',
            'CASCADE', 'CASCADE'
        );
        $this->createIndex('user_meta_idx', 'user_meta_changes', 'user_meta_id');
        $this->createIndex('user_idx', 'user_meta_changes', 'user_id');

        $this->createTable('user_meta_change_meta', [
            'id' => $this->primaryKey(),
            'user_meta_change_id' => $this->integer()->notNull(),
            'key' => $this->string(),
            'value' => $this->string()
        ]);
        $this->addForeignKey('user_meta_change_meta_user_meta_change_id',
            'user_meta_change_meta', 'user_meta_change_id',
            'user_meta_changes', 'id',
            'CASCADE', 'CASCADE'
        );
        $this->createIndex('user_meta_change_idx', 'user_meta_change_meta', 'user_meta_change_id');
    }

    public function down()
    {
        echo "m161010_094208_user_changes_tracking cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
