<?php

use backend\models\db\Account;
use backend\models\db\Debt;
use yii\db\Migration;
use yii\helpers\ArrayHelper;

class m161104_123557_debts_accounts_visibility extends Migration
{
    public function up()
    {
        $this->alterColumn('jar_changes', 'user_id', 'INT(11) NULL DEFAULT NULL');

        // first make sure that all cc/debt accounts have debts associated
        $accounts = Account::find()
            ->where(['and',
                ['account_type_id' => [2, 3]],
                ['archived' => 0]
            ])
            ->all();
        /** @var Account $account */
        foreach ($accounts as $account) {
            $defaultAccountId = $account->budget->default_account_id;
            $accountDebt = $account->getAccountDebts()->one();
            if (!$accountDebt) {
                Debt::createDebtFromForm([
                    'budget_id' => $account->budget_id,
                    'debt_type_id' => $account->account_type_id == 2 ? 1 : 14, // CC / Other
                    'account_id' => $defaultAccountId,
                    'active_debt_account_id' => $account->id,
                    'name' => $account->name,
                    'amount' => $account->account_type_id == 2 ? -1 * $account->balance : $account->balance
                ]);
            }
            elseif ($accountDebt->account_id != $accountDebt->active_debt_account_id) {
                // for active account make sure we have active debt
                $accountDebt->archived = 0;
                $accountDebt->save();
            }
        }

        // check all CC debts have accounts associated
        $debts = Debt::find()
            ->where(['and',
                ['debt_type_id' => 1],
                ['archived' => 0]
            ])
            ->all();
        foreach ($debts as $debt) {
            if ($debt->account_id == $debt->active_debt_account_id) {
                $defaultAccountId = $debt->budget->default_account_id;
                if (!$debt->getAccount()) {
                    // fix default account
                    $debt->account_id = $defaultAccountId;
                }
                $debtAccount = $debt->getActiveDebtAccount()->one();
                if (!$debtAccount) {
                    $debtAccount = new Account();
                    $debtAccount->setAttributes([
                        'budget_id' => $debt->budget_id,
                        'name' => $debt->name,
                        'balance' => -1 * $debt->amount,
                        'account_type_id' => 2
                    ]);
                }
                $debtAccount->archived = 0;
                $debtAccount->save();

                $debt->active_debt_account_id = $debtAccount->id;
                $debt->save();
            }
        }
    }

    public function down()
    {
        echo "m161104_123557_debts_accounts_visibility cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
