<?php

use backend\models\db\UserPlan;
use yii\db\Migration;

class m161124_154624_stripe_plans extends Migration
{
    public function up()
    {
        $this->createTable('user_plan_variations', [
            'id' => $this->primaryKey(),
            'name' => $this->string(255)->notNull(),
            'stripe_plan_id' => $this->string(255)->notNull(),
            'user_plan_type_id' => $this->integer()->notNull(),
            'plan_length' => $this->integer()->notNull(),
            'price' => $this->decimal(10, 2)->notNull(),
        ]);
        $this->createIndex('stripe_plan_idx', 'user_plan_variations', 'stripe_plan_id', true);

        $this->dropColumn('user_plan_types', 'cost');
        $this->dropColumn('user_plan_types', 'plan_length');
        $this->addColumn('user_plan_types', 'order', $this->integer()->notNull()->defaultValue(0));
        $this->update('user_plan_types', ['order' => 3], ['id' => 1]);
        $this->update('user_plan_types', ['name' => 'One on One Coaching', 'order' => 2], ['id' => 2]);
        $this->update('user_plan_types', ['order' => 4], ['id' => 3]);
        $this->update('user_plan_types', ['order' => 1], ['id' => 5]);

        $this->addColumn('user_plans', 'user_plan_variation_id', $this->integer()->null()->defaultExpression('NULL')->after('user_plan_type_id'));
        $this->addForeignKey('user_plans_user_plan_variation_id', 'user_plans', 'user_plan_variation_id',
            'user_plan_variations', 'id');
        $this->addColumn('user_plans', 'stripe_subscription_id', $this->string(255)->null()->defaultExpression('NULL')->after('user_plan_variation_id'));
        $this->addColumn('user_plans', 'valid_until', $this->timestamp()->null()->defaultExpression('NULL')->after('start_time'));

        $this->addColumn('invoices', 'stripe_invoice_id', $this->string(255)->null()->defaultExpression('NULL')->after('total'));


        // update user plan start time so it's always valid
        $userPlan = UserPlan::findOne(1);
        $userPlan->start_time = date('Y-m-d H:i:s', strtotime('-1 day'));
        $userPlan->save();
    }

    public function down()
    {
        echo "m161124_154624_stripe_plans cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
